﻿<%@ Page Inherits="TidyBlog.Web.Admin_CategoryList" Codebehind="CategoryList.aspx.cs" %>
<%@ Import Namespace="System.Data" %>
<!--#include file="HtmlInc/Header.html"-->
<table>
    <thead>
        <tr>
            <th style="width:12%;">编号</th>
            <th style="width:35%;">分类名</th>
            <th style="width:12%;">序号</th>
            <th style="width:16%;">文章数</th>
            <th style="width:25%;">操作</th>
        </tr>
    </thead>
    <tbody>
<% 
    if (CategoryList.Rows.Count > 0)
    {
        foreach (DataRow row in CategoryList.Rows)
        { 
%>
        <tr id="category-<%=row["CategoryId"]%>">
            <td class="categoryId"><%=row["CategoryId"]%></td>
            <td class="categoryName"><%=row["CategoryName"]%></td>
            <td class="seq"><%=row["Seq"]%></td>
            <td><%=row["PostCount"]%></td>
            <td class="center">
                <a href="#postForm" class="editLink" title="编辑分类<%=row["CategoryId"]%>">编辑</a>　
                <a href="?action=del&amp;categoryId=<%=row["CategoryId"]%>" class="delLink">删除</a>
            </td>
        </tr>
<%
        }
    }
    else
    {
%>
        <tr>
            <td colspan="5">暂无分类</td>
        </tr>
<%
    }
%>
    </tbody>
</table>
<form action="?action=create" method="post" id="postForm">
    <table class="fourCols">
        <thead>
            <tr>
                <th class="caption" colspan="4" id="formTitle">创建分类</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="4" class="buttons">
                    <input type="hidden" name="categoryId" id="categoryId" />
                    <input type="submit" value="提 交" />
                    <input type="button" value="取 消" id="cancelBtn" style="display:none;" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th>分类名</th>
                <td>
                    <input type="text" id="categoryName" name="categoryName" maxlength="20" style="width: 120px;" />
                    <em>* (20个字以内)</em>
                </td>
                <th>序号</th>
                <td>
                    <input type="text" id="seq" name="seq" maxlength="5" style="width: 40px;" />
                    <em>* (0-255，0为隐藏分类)</em>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[
(function() {
		  
var formMode = {

    cancelEditing: function() {
        $("#postForm").action = "?action=create";
        $("#formTitle").innerHTML = "创建管理员组";

        $("#categoryName").value = "";
        $("#categoryName").focus();
        $("#seq").value = "";

        $("#cancelBtn").style.display = "none";
    },

    editCategory: function(categoryId) {
        var categoryTds = $("#category-" + categoryId + " >td");
        if (categoryTds.length) {
            $("#postForm").action = "?action=update";
            $("#formTitle").innerHTML = "编辑分类 " + categoryTds[1].innerHTML;

            $("#categoryId").value = categoryId;
            $("#categoryName").value = categoryTds[1].innerHTML;
            $("#categoryName").focus();
            $("#seq").value = categoryTds[2].innerHTML;
            
            $("#cancelBtn").style.display = "inline";
        }
    }
};

$("#cancelBtn").addEvent("click", function() { formMode.cancelEditing(); });

$("a.editLink").addEvent("click", function(e) {
    e.preventDefault();
    formMode.editCategory(this.title.replace(/[^\d]+/, ""));
});

$("a.delLink").addEvent("click", function() { return confirm("确定要删除此分类吗"); });


var validator = new $.validate.FormValidator($("#postForm"));
validator.addRules("categoryName", ["noempty", "", "分类名不能为空"]);
validator.addRules("seq", ["noempty", "", "序号不能为空"], Number, ["min", 0, "序号必须为非负数"]);

})()
//]]></script>