﻿<%@ Page Inherits="TidyBlog.Web.Admin_CommentList" Codebehind="CommentList.aspx.cs" %>
<%@ Import Namespace="System.Data" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="" method="get">
    <table class="fourCols">
        <thead>
            <tr>
                <th colspan="4" class="caption">搜索评论<input type="hidden" name="action" value="search" /></th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="4" class="buttons">
                    <input type="submit" value="搜 索" />
                    <input id="clearKeys" type="button" value="清 空" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th><label for="postId">所属文章</label></th>
                <td>
                    <input type="text" id="postId" name="postId" style="width: 5em;" />
                    <em>(填写文章编号)</em>
                </td>
                <th><label>类型</label></th>
                <td>
                    <select id="visibility" name="visibility">
                        <option value="">所有</option>
                        <option value="0">未审核</option>
                        <option value="1">已审核</option>
                    </select>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<%
    if (CommentList != null)
    {
%>
<form id="listForm" method="post" action="?action=batch">
    <table>
        <thead>
            <tr>
                <th style="width: 5%;"><input id="selectAll" type="checkbox" /></th>
                <th style="width: 20%">所属文章</th>
                <th style="width: 12%;">作者</th>
                <th style="width: 16%;">发表时间</th>
                <th style="width: 7%;">状态</th>
                <th style="width: 32%;">内容</th>
                <th style="width: 8%;">操作</th>
            </tr>
        </thead>
<%
        if (CommentList.PageCount > 0)
        {
%>   
        <tfoot>
            <tr>
                <td class="pages" colspan="7">
<%
            for (int i = 1; i <= CommentList.PageCount; i++)
            {
                if (i == CommentList.CurrentPage)
                {
%>
                    <span><%=i %></span>
<%
                }
                else
                {
%>
                    <a href="?page=<%=i %>&amp;<%=QueryString %>"><%=i %></a>
<%
                }
            }
%>
                </td>
            </tr>
            <tr>
                <td colspan="7">
                    <select id="batchAction" name="batchAction">
                        <option value="verify">批量审核</option>
                        <option value="del">批量删除</option>
                    </select>
                    <input type="submit" value="执行" id="batchDelete" />
                </td>
            </tr>
        </tfoot>
        <tbody>
<%
            foreach (DataRow row in CommentList.Table.Rows)
            {
%>

            <tr>
                <td class="center"><input name="checkedIds" type="checkbox" value="<%=row["CommentId"] %>" /></td>
                <td><a href="../ShowPost<%=row["PostId"] %>.aspx" target="_blank"><%=row["Title"] %></a></td>
                <td><%=row["AuthorName"] %></td>
                <td><%=((DateTime)row["PostTime"]).AddHours(TimeDiff) %></td>
                <td class="center"><% if (0 == (byte)row["Visibility"]) { %>未审<% } else { %>已审<% } %></td>
                <td><%=row["Content"] %></td>
                <td class="center"><a href="###" class="showDetail">详细...</a></td>
            </tr>
            <tr class="detail" style="display: none; text-align: right;">
                <td colspan="7">IP：<%=row["IP"] %>　Email：<%=row["Email"] %>　主页：<%=row["HomePage"] %></td>
            </tr>
<%
            }
%>
        </tbody>
<%
        }
        else
        {
%>
        <tbody>
            <tr>
                <td colspan="7">暂无符合搜索条件的评论</td>
            </tr>
        </tbody>
<%
        }
%>
    </table>
</form>
<%
    }
%>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[
(function() {
		  
$("#clearKeys").addEvent("click", function() {
    $("#postId").value = "";
    $("#visibility").selectedIndex = 0;
});

$("#selectAll") && $("#selectAll").addEvent("click", function() {
    $("input[name=checkedIds]").attr("checked", this.checked);
});

$("a.showDetail").addEvent("click", function(e) {
    var node = this.parentNode.parentNode.nextSibling;
    while (node) {
        if ("TR" == node.nodeName) {
            node.style.display = "";
            break;
        } else {
            node = node.nextSibling;
        }
    }
    e.preventDefault();
});

$("#listForm") && $("#listForm").addEvent("submit", function() {
    return confirm("确认要执行这项操作吗?");
});

$("#postId").focus();

})()
//]]></script>