﻿<%@ Page CodeBehind="MessageList.aspx.cs" Inherits="TidyBlog.Web.Admin_MessageList" %>
<%@ Import Namespace="System.Data" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="" method="get">
    <table class="twoCols">
        <thead>
            <tr>
                <th colspan="2" class="caption">搜索留言<input type="hidden" name="action" value="search" /></th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="2" class="buttons">
                    <input type="submit" value="搜 索" />
                    <input id="clearKeys" type="button" value="清 空" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th><label>类型</label></th>
                <td>
                    <select id="visibility" name="visibility">
                        <option value="">所有</option>
                        <option value="0">未审核</option>
                        <option value="1">已审核</option>
                    </select>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<%
    if (MessageList != null)
    {
%>
<form id="listForm" method="post" action="?action=batch">
    <table>
        <thead>
            <tr>
                <th style="width: 5%;"><input id="selectAll" type="checkbox" /></th>
                <th style="width: 12%;">作者</th>
                <th style="width: 28%">作者信息</th>
                <th style="width: 16%;">发表时间</th>
                <th style="width: 7%;">状态</th>
                <th style="width: 32%;">内容</th>
            </tr>
        </thead>
<%
    if (MessageList.PageCount > 0)
    {
%>   
        <tfoot>
            <tr>
                <td class="pages" colspan="6">
<%
            for (int i = 1; i <= MessageList.PageCount; i++)
            {
                if (i == MessageList.CurrentPage)
                {
%>
                    <span><%=i %></span>
<%
                }
                else
                {
%>
                    <a href="?page=<%=i %>&amp;<%=QueryString %>"><%=i %></a>
<%
                }
            }
%>
                </td>
            </tr>
            <tr>
                <td colspan="6">
                    <select id="batchAction" name="batchAction">
                        <option value="verify">批量审核</option>
                        <option value="del">批量删除</option>
                    </select>
                    <input type="submit" value="执行" id="batchDelete" />
                </td>
            </tr>
        </tfoot>
        <tbody>
<%
            foreach (DataRow row in MessageList.Table.Rows)
            {
%>

            <tr>
                <td class="center"><input name="checkedIds" type="checkbox" value="<%=row["MsgId"] %>" /></td>
                <td><%=row["AuthorName"] %></td>
                <td>IP：<%=row["IP"] %><br />Email：<%=row["Email"] %><br />主页：<%=row["HomePage"] %></td>
                <td><%=((DateTime)row["PostTime"]).AddHours(TimeDiff) %></td>
                <td class="center"><% if (0 == (byte)row["Visibility"]) { %>未审<% } else { %>已审<% } %></td>
                <td><%=row["Content"] %></td>
            </tr>
<%
            }
%>
        </tbody>
<%
        }
        else
        {
%>
        <tbody>
            <tr>
                <td colspan="7">暂无符合搜索条件的留言</td>
            </tr>
        </tbody>
<%
        }
%>
    </table>
</form>
<%
    }
%>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[
(function() {
		  
$("#clearKeys").addEvent("click", function() {
    $("#postId").value = "";
    $("#visibility").selectedIndex = 0;
});

$("#selectAll") && $("#selectAll").addEvent("click", function() {
    $("input[name=checkedIds]").attr("checked", this.checked);
});

$("#listForm") && $("#listForm").addEvent("submit", function() {
    return confirm("确认要执行这项操作吗?");
});

})()
//]]></script>