﻿<%@ Page Inherits="TidyBlog.Web.Admin_PostList" Codebehind="PostList.aspx.cs" %>
<%@ Import Namespace="System.Data" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="" method="get" id="searchForm">
	<input type="hidden" id="page" name="page" />
    <table class="fourCols">
        <thead>
            <tr>
                <th class="caption" colspan="4">搜索文章<input type="hidden" name="action" value="search" /></th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="4" class="buttons">
                    <input type="submit" value="提 交" />
                    <input id="clearKeys" type="button" value="清 空" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th>文章标题</th>
                <td><input type="text" name="title" id="title" maxlength="50" style="width: 280px;" /></td>
                <th>所属分类</th>
                <td>
                    <select name="categoryId" id="categoryId">
                        <option value="">－请选择分类－</option>
<%
    if (CategoryList != null)
    {
        foreach (DataRow row in CategoryList.Rows)
        {
%>
                        <option value="<%=row["CategoryId"]%>"><%=row["CategoryName"]%></option>
<%
        }
    }
%>
                    </select>
                </td>
            </tr>
        </tbody>
    </table>
</form>

<%
    if (PostList != null)
    {
%>
<form action="?action=del" method="post" id="listForm">
    <table>
        <thead>
            <tr>
                <th style="width: 5%;"><input type="checkbox" id="selectAll" /></th>
                <th style="width: 28%;">标题</th>
                <th style="width: 16%;">分类</th>
                <th style="width: 15%;">作者</th>
                <th style="width: 18%;">发表时间</th>
                <th style="width: 10%;">状态</th>
                <th style="width: 8%;">操作</th>
            </tr>
        </thead>
<%
        if (PostList.PageCount > 0)
        {
%>
        <tfoot>
            <tr>
                <td class="pages" colspan="7">
<%
            for (int i = 1; i <= PostList.PageCount; i++)
            {
                if (i == PostList.CurrentPage)
                {
%>
                <span><%=i%></span>
<%
                }
                else
                {
%>
                <a href="?page=<%=i%>&amp;<%=QueryString%>"><%=i%></a>
<%
                }
            }
%>
                </td>
            </tr>
            <tr>
                <td colspan="7">
                    <input type="submit" value="批量删除" />
                </td>
            </tr>
        </tfoot>
        <tbody>
<%
            foreach (DataRow row in PostList.Table.Rows)
            {
%>
            <tr>
                <td class="center"><input name="checkedIds" type="checkbox" value="<%=row["PostId"] %>" /></td>
                <td><a href="../ShowPost<%=row["PostId"] %>.aspx" target="_blank"><%=row["Title"] %></a></td>
                <td><%=row["CategoryName"] %></td>
                <td><%=row["AuthorName"] %></td>
                <td><%=((DateTime)row["PostTime"]).AddHours(TimeDiff) %></td>
                <td class="center">
<%
                    switch (row["State"].ToString())
                    {
                        case "0":
                            Response.Write("私有");
                            break;
                        
                        case "1":
                            Response.Write("用户可查看");
                            break;
                            
                        case "2":
                            Response.Write("完全公开");
                            break;
                    }
%>
                </td>
                <td class="center">
                    <a href="UpdatePost.aspx?postId=<%=row["PostId"] %>">编辑</a>
                </td>
            </tr>
        </tbody>
<%
            }
        }
        else
        {
%>
        <tbody>
            <tr>
                <td colspan="7">没有符合搜索条件的记录</td>
            </tr>
        </tbody>
<%
        }
%>
        
    </table>
</form>
<%
    }
%>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[
(function() {

$("#listForm") && $("#listForm").addEvent("submit", function() {
    return confirm("确认要删除选定的文章吗?");
});
$("#selectAll") && $("#selectAll").addEvent("click", function() {
    $("input[name=checkedIds]").attr("checked", this.checked);
});

$("#clearKeys").addEvent("click", function() {
    $("#title").value = "";
    $("#categoryId").selectedIndex = 0;
});

$("#title").focus();

})()
//]]></script>