﻿<%@ Page Inherits="TidyBlog.Web.Admin_RegUser" Codebehind="RegUser.aspx.cs" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="?action=create" method="post">
    <table class="twoCols">
        <thead>
            <tr>
                <th class="caption" colspan="2">注册新用户</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="2" class="buttons">
                    <input type="submit" value="提 交" />
                    <input type="reset" value="重 置" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th>用 户 名</th>
                <td>
                    <input type="text" id="userName" name="userName" maxlength="30" style="width: 180px;" />
                    <em>* (注册后不可更改，2-30个字符) </em>
                </td>
            </tr>
            <tr>
                <th>密　　码</th>
                <td>
                    <input type="password" id="password" name="password" maxlength="16" style="width: 140px;" />
                    <em>* (6-16个字符)</em>
                </td>
            </tr>
            <tr>
                <th>重复密码</th>
                <td>
                    <input type="password" id="password2" maxlength="16" style="width: 140px;" />
                    <em>* (重复一次上面输入的密码)</em>
                </td>
            </tr>
            <tr>
                <th>真实姓名</th>
                <td>
                    <input type="text" name="trueName" id="trueName" maxlength="30" style="width: 120px;" />
                    <em>(30个字以内)</em>
                </td>
            </tr>
            <tr>
        	    <th>性　别</th>
                <td>
            	    <input type="radio" name="gender" value="true" checked="checked" /> 男
                    <input type="radio" name="gender" value="false" />女
                    <em>*</em>
                </td>
            </tr>
            <tr>
        	    <th>用户类型</th>
                <td>
            	    <select name="isAdmin">
                        <option value="false" selected="selected">普通用户</option>
                        <option value="true">管理员</option>
                    </select>
                    <em>*</em>
                </td>
            </tr>
            <tr>
                <th>电子邮箱</th>
                <td>
                    <input type="text" name="email" id="email" maxlength="80" style="width: 250px;" />
                    <em>(80个字符以内)</em>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[
(function() {
		  
// 是否包含Html特殊字符的验证规则
$.validate.FormValidator.rules["hashtml"] = function(val) { return !/<|>|"|'|&/.test(val); };

var validator = new $.validate.FormValidator($("form")[0]);
validator.addRules("userName", ["noempty", "", "用户名不能为空"], ["hashtml", "", "用户名不能包含Html特殊字符"]);
validator.addRules(
	"password",
	["minlen", 6, "密码最少应包含6个字符"],
	[function(value) { return value == $("#password2").value.trim(); }, "两次密码输入不一致"]
);
validator.addRules("trueName", ["hashtml", "", "真实姓名不能包含Html特殊字符"]);
validator.addRules(
	"email",
	[function(value) { if (value != "") { return value.indexOf("@") >= 1; } }, "错误的Email格式"],
	["hashtml", "", "Email地址不能包含Html特殊字符"]
);


$("#userName").focus();

})()
//]]></script>
