﻿<%@ Page Inherits="TidyBlog.Web.Admin_UpdateLink" Codebehind="UpdateLink.aspx.cs" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="?action=update" method="post">
    <table class="twoCols">
        <thead>
            <tr>
                <th class="caption" colspan="2">编辑链接 <input type="hidden" name="LinkId" value="<%=CurLink.LinkId%>" /></th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="2" class="buttons">
                    <input type="submit" value="提 交" />
                    <input type="reset" value="重 置" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th>链 接 名</th>
                <td>
                    <input type="text" id="linkName" name="linkName" maxlength="15" style="width: 180px;" value="<%=CurLink.LinkName%>" />
                    <em>* (15个字以内)</em>
                </td>
            </tr>
            <tr>
                <th>链接地址</th>
                <td>
                    <input type="text" id="linkUrl" name="linkUrl" maxlength="60" style="width: 280px;" value="<%=CurLink.LinkUrl%>" />
                    <em>* (60个字符以内)</em>
                </td>
            </tr>
            <tr>
                <th>Logo地址</th>
                <td>
                    <input type="text" id="logoUrl" name="logoUrl" maxlength="80" style="width: 350px;" value="<%=CurLink.LogoUrl%>" />
                    <em>(80个字符以内)</em>
                </td>
            </tr>
            <tr>
                <th>链接说明</th>
                <td>
                    <input type="text" name="introduction" id="introduction" maxlength="30" style="width: 250px;" value="<%=CurLink.Introduction%>" />
                    <em>(30个字以内)</em>
                </td>
            </tr>
            <tr>
        	    <th>序　　号</th>
                <td>
            	    <input type="text" id="seq" name="seq" maxlength="5" style="width: 40px;" value="<%=CurLink.Seq%>" />
                    <em>* (必须为正整数)</em>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript">//<![CDATA[
(function() {

var validator = new $.validate.FormValidator($("form")[0]);
validator.addRules("linkName", ["noempty", "", "链接名不能为空"]);
validator.addRules("linkUrl", ["noempty", "", "链接地址不能为空"]);
validator.addRules("seq", ["noempty", "", "序号不能为空"], Number, ["min", 0, "序号必须为大于等于0的数字"]);

$("#linkName").focus();

})()
//]]></script>