﻿<%@ Page Inherits="TidyBlog.Web.Admin_UpdatePost" Codebehind="UpdatePost.aspx.cs" %>
<%@ Import Namespace="System.Data" %>
<%@ Import Namespace="TidyBlog.BLL" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="?action=update" method="post" id="postForm" enctype="multipart/form-data">
    <table class="fourCols">
        <thead>
            <tr>
                <th colspan="4" class="caption">编辑文章 <input type="hidden" name="postId" value="<%=CurPost.PostId %>" /></th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="4" class="buttons">
                    <input type="submit" value="提 交" />
                    <input type="reset" value="恢 复" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th><label for="title">标题</label></th>
                <td colspan="3">
                    <input type="text" id="title" name="title" value="<%=CurPost.Title %>" maxlength="80" style="width: 280px;" />
                    <em>* (2-80个字符)</em>
                </td>
            </tr>
            <tr>
                <th><label for="keyword">关键字</label></th>
                <td colspan="3">
                    <input id="keywords" name="keywords" type="text" value="<%=CurPost.Keywords %>" maxlength="80" style="width: 260px;" />
                    <em>(80个字符以内，每个关键字之间用英文逗号隔开)</em>                
                </td>
            </tr>
            <tr>
                <th><label for"categoryId">分类</label></th>
                <td>
                    <select id="categoryId" name="categoryId">
<%
    if (CategoryList != null)
    {
        foreach (DataRow row in CategoryList.Rows)
        {
%>
                        <option value="<%=row["CategoryId"]%>"<% if (CurPost.CategoryId.ToString() == row["CategoryId"].ToString()) { %> selected="selected"<% } %>><%=row["CategoryName"]%></option>
<%
        }
    }
%>
                    </select>
                    <em>*</em>
                </td>
                <th><label for="state">公开度</label></th>
                <td>
                    <select id="state" name="state">
                        <option value="2"<% if (CurPost.State == 2) { %> selected="selected"<% } %>>所有人可查看</option>
                        <option value="0"<% if (CurPost.State == 0) { %> selected="selected"<% } %>>私有</option>
                        <option value="1"<% if (CurPost.State == 1) { %> selected="selected"<% } %>>本博客用户可查看</option>
                    </select>
                    <em>*</em>
                </td>
            </tr>
            <tr>
                <th><label for"summaryLength">摘要长度</label></th>
                <td>
                    约
                    <input type="text" id="summaryLength" name="summaryLength" maxlength="4" style="width: 40px;" value="<%=CurPost.SummaryLength > 0 ? CurPost.SummaryLength.ToString() : String.Empty %>"<% if (CurPost.SummaryLength <= 0) { %> readonly="readonly"<% } %> />
                    个字符　
                    <input id="isFullSummary" type="checkbox"<% if (CurPost.SummaryLength <= 0) { %> checked="checked"<% } %> />
                    <label for="isFullSummary">使用内容作为摘要</label>
                    <em>*</em>
                </td>
                <th><label for="isUpdateTime">更新发表时间</label></th>
                <td>
                    <select id="isUpdateTime" name="isUpdateTime">
                        <option value="false" selected="selected">否</option>
                        <option value="true">是</option>
                    </select>
                    <em>*</em>
                </td>
            </tr>
            <tr>
                <td colspan="4">
                    <iframe src="../TidyEditor/TidyEditor.html?id=tidyEditor" frameborder="0" id="tidyEditor" class="tidyEditor" scrolling="no"></iframe>
                    <input id="content" name="content" type="hidden" value="" />
                </td>
            </tr>
            <tr>
                <th><label for="newFileCount">上传附件</label></th>
                <td colspan="3">
                    <div>添加 <input type="text" id="newFileCount" maxlength="3" value="1" class="text" style="width: 30px;" /> 个文件 <input type="button" value="添 加" class="button" id="addFile" /></div>
                    <ul id="uploadFiles"></ul>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<div id="oldContent"><!--
<%=CurPost.Content %>
--></div>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript" src="../Js/Post.js"></script>