﻿<%@ Page Inherits="TidyBlog.Web.Admin_UpdateUser" Codebehind="UpdateUser.aspx.cs" %>
<!--#include file="HtmlInc/Header.html"-->
<form action="?action=update&userId=<%=CurUser.UserId%>" method="post" enctype="multipart/form-data">
    <table class="twoCols">
        <thead>
            <tr>
                <th class="caption" colspan="2">编辑用户资料</th>
            </tr>
        </thead>
        <tfoot>
            <tr>
                <td colspan="2" class="buttons">
                    <input type="submit" value="提 交" />
                    <input type="reset" value="重 置" />
                </td>
            </tr>
        </tfoot>
        <tbody>
            <tr>
                <th>用 户 名</th>
                <td><%=CurUser.UserName%></td>
            </tr>
            <tr>
                <th>密　　码</th>
                <td>
                    <input type="password" id="password" name="password" maxlength="16" style="width: 140px;" />
                    <em>(6-16个字符，不改请留空)</em>
                </td>
            </tr>
            <tr>
                <th>重复密码</th>
                <td>
                    <input type="password" id="password2" maxlength="16" style="width: 140px;" />
                    <em>(重复一次上面输入的密码)</em>
                </td>
            </tr>
            <tr>
                <th>真实姓名</th>
                <td>
                    <input type="text" name="trueName" id="trueName" maxlength="30" style="width: 120px;" value="<%=CurUser.TrueName%>" />
                    <em>(30个字以内)</em>
                </td>
            </tr>
            <tr>
                <th>出生年月</th>
                <td>
                    <input type="text" name="dateOfBirth" id="dateOfBirth" maxlength="7" style="width:6em;" value="<%=CurUser.DateOfBirth%>" />
                    <em>(格式“年-月”，例如“2008-7”)</em>
                </td>
            </tr>
            <tr>
        	    <th>性　别</th>
                <td>
            	    <input type="radio" name="gender" value="true"<% if (CurUser.Gender) { %> checked="checked"<% } %> /> 男
                    <input type="radio" name="gender" value="false"<% if (!CurUser.Gender) { %> checked="checked"<% } %> /> 女
                    <em>*</em>
                </td>
            </tr>
            <tr>
        	    <th>用户类型</th>
                <td>
            	    <select name="isAdmin" id="isAdmin">
                        <option value="false"<% if (!CurUser.IsAdmin) { %> selected="selected"<% } %>>普通用户</option>
                        <option value="true"<% if (CurUser.IsAdmin) { %> selected="selected"<% } %>>管理员</option>
                    </select>
                    <em>*</em>
                </td>
            </tr>
            <tr>
                <th>头像地址</th>
                <td>
                    <select name="headUrlType" id="headUrlType">
                    	<option value="0" selected="selected">不修改</option>
                    	<option value="1">Url</option>
                        <option value="2">上传</option>
                        <option value="3">恢复默认头像</option>
                    </select>
                    <input type="file" name="headUpload" id="headUpload" style="display: none;" />
                    <input type="text" name="wwwUrl" id="wwwUrl" maxlength="80" style="width: 300px; display: none;" />
                    <input type="hidden" name="oldUrl" value="<%=CurUser.HeadUrl%>" />
                    <em>*</em>
                </td>
            </tr>
            <tr>
                <th>电子邮件</th>
                <td>
                    <input type="text" name="email" id="email" maxlength="80" style="width: 250px;" value="<%=CurUser.Email%>" />
                    <em>(80个字以内)</em>
                </td>
            </tr>
            <tr>
                <th>QQ 号码</th>
                <td>
                    <input type="text" name="qq" id="qq" maxlength="20" style="width: 150px;" value="<%=CurUser.QQ%>" />
                    <em>(20个数字以内)</em>
                </td>
            </tr>
            <tr>
                <th>个人主页</th>
                <td>
                    <input type="text" name="homePage" id="homePage" maxlength="80" style="width: 200px;" value="<%=CurUser.HomePage%>" />
                    <em>(80个字以内)</em>
                </td>
            </tr>
            <tr>
                <th>来自</th>
                <td>
                    <input type="text" name="hometown" id="hometown" maxlength="30" style="width: 120px;" value="<%=CurUser.Hometown%>" />
                    <em>(30个字以内)</em>
                </td>
            </tr>
            <tr>
                <th>个人兴趣</th>
                <td>
                    <textarea rows="5" cols="80" name="interests" id="interests" style="width: 400px; height: 80px;"><%=CurUser.Interests%></textarea>
                </td>
            </tr>
            <tr>
                <th>个人简介</th>
                <td>
                    <textarea rows="5" cols="80" name="introduction" id="introduction" style="width: 400px; height: 80px;"><%=CurUser.Introduction%></textarea>
                </td>
            </tr>
            <tr>
                <th>注册时间</th>
                <td>
                    <input type="text" name="regTime" id="regTime" style="width: 140px;" value="<%=CurUser.RegTime%>" />
                    <em>* (标准UTC时间)</em>
                </td>
            </tr>
        </tbody>
    </table>
</form>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript" src="../Js/User.js"></script>