﻿<%@ Page Inherits="TidyBlog.Web.CreatePost" Codebehind="CreatePost.aspx.cs" %>
<%@ Import Namespace="System.Data" %>
<!--#include file="HtmlInc/HtmlBegin.html"-->
<div id="wrapper">
	<div id="subWrapper">
        <div id="main">
            <!--#include file="HtmlInc/Header.html"-->
            <form id="postForm" class="form" action="?action=post" method="post" enctype="multipart/form-data">
                <table>
                    <tfoot>
                        <tr>
                            <td colspan="4" class="btns">
                                <input type="submit" value="提 交" class="button" />
                                <input type="reset" value="重 置" class="button" />
                            </td>
                        </tr>
                    </tfoot>
                    <tbody>
                        <tr>
                            <th><label for="title"><em class="required">*</em> 标题</label></th>
                            <td colspan="3">
                                <input id="title" name="title" type="text" class="text" maxlength="80" style="width: 350px;" />
                                <br /><em class="tips">(2-80个字符)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="keywords">关键字</label></th>
                            <td colspan="3">
                                <input id="keywords" name="keywords" type="text" class="text" maxlength="80" style="width: 320px;" />
                                <br /><em class="tips">(80个字符以内，每个关键字之间用英文逗号隔开)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="categoryId"><em class="required">*</em> 所属分类</label></th>
                            <td style="width: 35%;">
                                <select id="categoryId" name="categoryId" class="select">
                                    <option value="">－请选择分类－</option>
<%
    foreach (DataRow row in CategoryList.Rows)
    {
%>
                                    <option value="<%=row["CategoryId"]%>"><%=row["CategoryName"]%></option>
<%
    }
%>
                                </select>
                            </td>
                            <th><label for="state"><em class="required">*</em> 公开度</label></th>
                            <td style="width: 35%;">
                                <select id="state" name="state" class="select">
                                    <option value="2" selected="selected">所有人可查看</option>
                                    <option value="0">私有</option>
                                    <option value="1">本博客用户可查看</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="summaryLength"><em class="required">*</em> 摘要长度</label></th>
                            <td colspan="3">
                                约
                                <input id="summaryLength" name="summaryLength" class="text" maxlength="4" style="width: 40px;" value="<%=ArticleSetupBLL.Read("SummaryLength") %>" />
                                个字符　
                                <input id="isFullSummary" type="checkbox" />
                                <label for="isFullSummary">使用内容作为摘要</label>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                            	<iframe src="TidyEditor/TidyEditor.html?id=tidyEditor" frameborder="0" id="tidyEditor" class="tidyEditor" scrolling="no"></iframe>
                                <input id="content" name="content" type="hidden" value="" />
                            </td>
                        </tr>
                        <tr>
                            <th>上传附件</th>
                            <td colspan="3">
                                <ul id="uploadFiles"></ul>
                                <div>添加 <input type="text" id="newFileCount" maxlength="3" value="1" class="text" style="width: 30px;" /> 个文件 <input type="button" value="添 加" class="button" id="addFile" /></div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>
        <!--#include file="HtmlInc/SideBar.html"-->
	</div>
</div>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript" src="Js/Post.js"></script>