﻿<%@ WebHandler Language="C#" Class="TidyBlog.Web.FileTransfer" %>

using System;
using System.Text.RegularExpressions;
using System.IO;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using TidyBlog.Util;
using TidyBlog.BLL;

namespace TidyBlog.Web
{
    public class FileTransfer : IHttpHandler
    {
        public void ProcessRequest(HttpContext context)
        {
            string fileName = context.Request.QueryString["fileName"];

            if (!String.IsNullOrEmpty(fileName))
            {
                context.Response.Clear();
                context.Response.ClearHeaders();

                // 获取UrlReferrer
                string referHost = String.Empty;
                if (context.Request.UrlReferrer != null)
                {
                    referHost = context.Request.UrlReferrer.Host.ToLower();
                }

                if (!String.IsNullOrEmpty(referHost))
                {
                    string domain = BasicSetupBLL.Read("Domain"), externalHosts = ArticleSetupBLL.Read("AllowExternalHosts");
                    Regex reExternalHosts = StringFormatter.MultiLineRulesToRegex(externalHosts, false, true);

                    if ((!String.IsNullOrEmpty(domain) && referHost == CommonRegex.FormatDomain.Replace(domain, "")) ||
                        (reExternalHosts != null && reExternalHosts.IsMatch(referHost)))
                    {
                        FileInfo file = new FileInfo(context.Server.MapPath(ConfigurationManager.AppSettings["UploadFolder"] + fileName.Substring(0, 6) + "/" + fileName));

                        if (file.Exists)
                        {
                            context.Response.AddHeader("Content-Disposition", "attachment; filename=" + fileName);
                            context.Response.AddHeader("Content-Length", file.Length.ToString());
                            context.Response.ContentType = "application/octet-stream";
                            context.Response.TransmitFile(file.FullName);
                        }
                        else
                        {
                            context.Response.ContentType = "text/plain";
                            context.Response.Write("File Not Found");
                        }

                        return;
                    }

                    //referHost = domain + "," + externalHosts + "," + referHost;
                }

                context.Response.ContentType = "text/plain";
                context.Response.Write("Hot Link Protection: " + referHost);
            }
        }     
            
       
        public bool IsReusable
        {
            get { return false; }
        }
    }
}