(function() {

// 修复Url格式
$.util.fixUrl = function(url) {
    if (url != "") {
        if (!/^https?:\/\//.test(url)) {
            url = "http://" + url;
        } else if (/^https?:\/\/$/.test(url)) {
            url = "";
        }
    }
    
    return url;
};
// 输出Email，防垃圾扫描
$.util.getEmail = function(domain, user) {
	return user + "@" + domain;
};

var valRules = $.validate.FormValidator.rules;
// 是否包含Html特殊字符的验证规则
valRules["hashtml"] = function(val) { return !/<|>|"|'|&/.test(val); };
// Email验证规则
valRules["email"] = function(val) {
	var pos = val.indexOf("@");
	if (pos <= 0 || pos == val.length - 1) {
		return false;
	}
};
// URL验证规则
valRules["url"] = function(val) {
	return !/<|>|"|'/.test(val);
};


var loginWin = $("#loginWin");
if (loginWin) {
	loginWin = new $.ui.Win(loginWin);
	$("#toLogin").addEvent("click", function(e) {
		loginWin.show();
		var userName = $("#userName");
		if ("" == userName.value.trim()) {
			userName.focus();
		} else {
			$("#password").focus();
		}
		
		e.preventDefault();
	});
}

var loginForm = $("form.loginForm")[0];
if (loginForm) {
	var loginValidator = new $.validate.FormValidator(loginForm);
	loginValidator.addRules("userName", ["minlen", 2, "用户名最少应包含2个字符"], ["hashtml", "", "用户名不能包含Html特殊字符"]);
	loginValidator.addRules("password", ["minlen", 6, "密码最少应包含6个字符"]);
}

// 多用户滚动显示
var aboutUs = $("#aboutUs ul");
if (aboutUs.length) {
	members = aboutUs.$("li");
	if (members.length > 1) {
		var scrollMembers = new $.ui.Marquee(aboutUs[0], "top"), len = 96,
			scrollFn = scrollMembers.start.bind(scrollMembers, len, function() {
				setTimeout(scrollFn, 3000);
			});
		setTimeout(scrollFn, 3000);
	}
}


// 把Cookie中的用户名写到登录表单
$("input[name=userName]").attr("value",  $.cookie.get("UserName") || "");

})()