﻿(function() {

var input_authorName = $("#authorName"), input_email = $("#email"),
	input_homePage = $("#homePage"), textarea_content = $("#content")
    replyValidator = new $.validate.FormValidator($("form.commentForm")[0]);

input_authorName && replyValidator.addRules("authorName",
    ["noempty", 0, "请填写您的称呼"],
    ["hashtml", 0, "称呼不能包含Html特殊字符"]
);
input_email && replyValidator.addRules("email",
    ["noempty"],
	["email", 0, "错误的Email格式"],
	["hashtml", 0, "Email不能包含Html特殊字符"]
);
input_homePage && replyValidator.addRules("homePage",
	["noempty"], $.util.fixUrl,
	["url", 0, "主页地址不能包含Html特殊字符"]
);
replyValidator.addRules("content", ["noempty", "", "请填写内容"]);
replyValidator.onSuccess = function() {
    if (input_authorName && input_email && input_homePage) {
		var authorName = input_authorName.value.trim(),
			email = input_email.value.trim(),
			homePage = input_homePage.value.trim();
        
		authorName && $.cookie.set("authorName", authorName, "1y");
        email && $.cookie.set("email", email, "1y");
        homePage.replace(/^https?:\/\//i, "") && $.cookie.set("homePage", homePage, "1y");
    }
};

if (input_authorName && input_email && input_homePage) {
    var author = {
        name : $.cookie.get("authorName"),
        email : $.cookie.get("email"),
        homePage : $.cookie.get("homePage")
    };

    author.name && (input_authorName.value = author.name);
    author.email && (input_email.value = author.email);
    author.homePage && (input_homePage.value = author.homePage);
}


$("#postComment") && $("#postComment").addEvent("click", function(e) {
    e.preventDefault();
	if (input_authorName && "" == input_authorName.value.trim()) {
        input_authorName.focus();
    } else {
        textarea_content.focus();
    }
});

})()