﻿(function() {

// 模板
var templates = {};
templates["uploadItem"] = '%1. <input name="file%1" id="file%1" type="file" class="text" /> <a href="###" onclick="return uploadManager.insertLink(\'%1\');">插入链接</a> | <a href="###" onclick="return uploadManager.insertImage(\'%1\');">插入图片</a> | <a href="###" onclick="return uploadManager.delFile(\'%1\');">删除</a>';
templates["uploadUrl"] = "@file%1Url@";
templates["uploadLink"] = '<a href="' + templates["uploadUrl"] + '" target="_blank">%2</a>';
templates["uploadImage"] = '<img src="' + templates["uploadUrl"] + '" alt="%2" />';


var uploadList = $("#uploadFiles"),		// 文件列表
	fileCount = 0;						// 当前文件数

/// 上传管理器
var uploadManager = {

	/// 增加上传文件
	/// param {Number} 文件数
	addFile : function(n) {
		var frag = document.createDocumentFragment();
		while (--n >= 0) {
			var li = document.createElement("li"), newSeq = String("0" + (++fileCount)).right(2);
			li.className = "file" + newSeq;
			li.innerHTML = String.format(templates["uploadItem"], newSeq);
			frag.appendChild(li);
		}
		uploadList.appendChild(frag);
	},

	/// 删除文件
	/// @param {Number} 序号
	delFile : function(n) {
		uploadList.removeChild(uploadList.$("li.file" + n)[0]);
		/*tidyEditor.delFile(
			String.format(templates["uploadUrl"], n)
		);*/
		return false;
	},

	/// 插入文件链接
	/// @param {Number} 序号
	insertLink : function(n) {
		var text = prompt("请输入链接文本", "");
		text != null && tidyEditor.command.insertHtml(
			String.format(templates["uploadLink"], n, text)
		);
		return false;
	},
	
	/// 插入图片
	/// @param {Number} 序号
	insertImage : function(n) {
		var text = prompt("请输入图片说明", "");
		text != null && tidyEditor.command.insertHtml(
			String.format(templates["uploadImage"], n, text)
		);
		return false;
	}
};

window.uploadManager = uploadManager;


// 编辑器对象
var editorFrame = $("#tidyEditor"), tidyEditor, tempHost;

function initEditor() {
	tidyEditor = editorFrame.contentWindow.tidyEditor;
	if (tidyEditor) {
		editorFrame.style.visibility = "visible";
		tempHost = "http://" + document.location.host + "/";
		var oldContent = $("#oldContent");
		tidyEditor.init("../Css/Preview.css", tempHost, oldContent ? oldContent.innerHTML.replace(/(?:^\s*<!--\s*)|(?:\s*-->\s*$)/g, "") : "");
		tidyEditor.focus();
	} else {
		setTimeout(arguments.callee, 350);
	}
}
initEditor();


var summaryLength = "";
$("#isFullSummary").addEvent("click", function() {
	if (this.checked) {
		summaryLength = $("#summaryLength").value;
		$("#summaryLength").attr("value", "").readOnly = true;
	} else {
		$("#summaryLength").attr("value", summaryLength).readOnly = false;
	}
});


$("#addFile").addEvent("click", function() {
	var count = parseInt($("#newFileCount").value);
	if (isNaN(count) || count <= 0) {
		alert("文件个数必须为大于0的数字");
	} else {
		uploadManager.addFile(count);
	}
});


var postValidator = new $.validate.FormValidator($("#postForm"));
postValidator.onSubmit = function() {
	var content = tidyEditor ? tidyEditor.getXhtml() : "";
	$("#content").value = content.replace(
		new RegExp("((?:(?:src)|(?:href))=(['\"]?))" + tempHost.replace(/\//g, "\\/") + "(.*?)\\2", "gi")
	, function($0, $1, $2, $3) {
		return "" == $3 ? $0 : $1 + $3 + $2
	});
};
postValidator.addRules("title", ["noempty", "", "请填写标题"]);
postValidator.addRules("categoryId", ["noempty", "", "请选择分类"]);
postValidator.addRules("summaryLength", ["noempty"], Number,
    ["min", 50, "摘要长度不能小于50"],
    ["max", 5000, "摘要长度不能大于5000"]
);
postValidator.addRules("content", ["noempty", "", "请填写内容"]);


$("#title").focus();

})()