﻿(function() {

var headManager = {
	urlControl : $("#wwwUrl"),
	uploadControl : $("#headUpload"),
	
	updateByUpload : function() {
		this.urlControl.style.display = "none";
		this.uploadControl.style.display = "";
	},
	updateByUrl : function() {
		this.urlControl.style.display = "";
		this.uploadControl.style.display = "none";
	},
	noUpdate : function() {
		this.urlControl.style.display = "none";
		this.uploadControl.style.display = "none";
	}
};

$("#headUrlType").addEvent("change", function() {
	switch (this.value) {
		case "0":
			headManager.noUpdate();
		break;
		
		case "1":
			headManager.updateByUrl();
		break;
		
		case "2":
			headManager.updateByUpload();
		break;
		
		case "3":
			headManager.noUpdate();
		break;
	}
});


// 是否包含Html特殊字符的验证规则
$.validate.FormValidator.rules["hashtml"] = function(val) { return !/<|>|"|'|&/.test(val); };

var validator = new $.validate.FormValidator($("form")[0]);
validator.addRules(
	"password",
	[function(value) { if (value != "") { return value.length > 6; } }, "密码最少应包含6个字符"],
	[function(value) { return value == $("#password2").value.trim(); }, "两次密码输入不一致"]
);
validator.addRules("trueName", ["hashtml", "", "真实姓名不能包含Html特殊字符"]);
validator.addRules(
	"email",
	[function(value) {
		if (value != "") {
			return value.indexOf("@") >= 1;
		}
	}, "错误的Email格式"],
	["hashtml", "", "Email地址不能包含Html特殊字符"]
);
validator.addRules("dateOfBirth", [function(value) {
	if (value != "") {
		return /^\d{4}-\d{1,2}$/.test(value);
	}
}, "出生年月的格式必须为“年-月”，例如“1990-9”"]);
validator.addRules("qq", [function(value) {
	if (value != "") {
		return /^\d{2,20}$/.test(value);
	}
}, "QQ号码必须为2-20位数字"]);
validator.addRules("homePage", ["hashtml", "", "主页地址中不能包含Html特殊字符"]);

})()