﻿<%@ WebHandler Language="C#" Class="TidyBlog.Web.Rss" %>

using System;
using System.Text;
using System.Collections.Generic;
using System.Web;
using System.Globalization;
using System.Data;
using TidyBlog.BLL;
using TidyBlog.Entity;
using TidyBlog.Data;


namespace TidyBlog.Web
{
    public class Rss : IHttpHandler
    {
        /// <summary>
        /// 显示的记录数
        /// </summary>
        protected const int PageSize = 10;
        
        public void ProcessRequest (HttpContext context)
        {
            context.Response.ContentType = "text/xml";
            
            StringBuilder content = new StringBuilder();
            content.AppendLine("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            content.AppendLine("<rss version=\"2.0\">");
            content.AppendLine("<channel>");
            content.AppendLine("<title>" + BasicSetupBLL.Read("BlogName") + "</title>");
            content.AppendLine("<link>" + BasicSetupBLL.Read("Domain")  + "</link>");
            content.AppendLine("<description>" + BasicSetupBLL.Read("BlogIntro") + "</description>");

            DataPaging newPosts = new DataPaging(PageSize, 1);

            Dictionary<string, string> paramList = new Dictionary<string, string>();
            // 只请求完全可见的文章
            paramList.Add("state", "2");

            try
            {
                newPosts = PostBLL.GetList(newPosts, paramList);
            }
            catch
            {
                newPosts.PageCount = 0;
            }
            
            if (BasicSetupBLL.Read("IsOpened").Equals("2") && newPosts.PageCount > 0)
            {
                double dateDiff = Double.Parse(BasicSetupBLL.Read("TimeDiff"));
                TimeSpan timeSpan = new TimeSpan((long)(dateDiff * 60 * 60 * 10000000));
                string domain = BasicSetupBLL.Read("Domain").Trim(new[] { '/' });
                
                foreach (DataRow row in newPosts.Table.Rows)
                {
                    content.AppendLine("<item>");
                    content.AppendLine("<title>" + row["Title"].ToString() + "</title>");
                    content.AppendLine("<link>" + domain + "/ShowPost" + row["PostId"].ToString() + ".aspx</link>");
                    content.AppendLine("<pubDate>" + new DateTimeOffset(Convert.ToDateTime(row["PostTime"].ToString()).AddHours(dateDiff), timeSpan).ToString("dddd, MMM dd yyyy HH:mm:ss zzz", CultureInfo.InvariantCulture) + "</pubDate>");
                    content.AppendLine("<description><![CDATA[" + row["Summary"].ToString() + "]]></description>");
                    content.AppendLine("</item>");
                }
            }
            
            content.AppendLine("</channel>");
            content.AppendLine("</rss>");

            context.Response.Write(content.ToString());
        }
     
        public bool IsReusable
        {
            get { return false; }
        }

    }
}