﻿<%@ Page Inherits="TidyBlog.Web.ShowComments" Codebehind="ShowComments.aspx.cs" %>
<!--#include file="HtmlInc/HtmlBegin.html"-->
<div id="wrapper">
	<div id="subWrapper">
        <div id="main">
            <!--#include file="HtmlInc/Header.html"-->
            <div class="post">
<%
    CurPost.PostTime = CurPost.PostTime.AddHours(TimeDiff);
%>
                <div class="postHeader">
                    <div class="date"><%=CurPost.PostTime.ToString("yy-MM")%> <span class="day"><%=CurPost.PostTime.Day%></span></div>
                    <h2><a href="ShowPost<%=CurPost.PostId%>.aspx"><%=CurPost.Title%></a></h2>
                    <ul>
                        <li>作者：<a href="ShowBlogger<%=CurPost.AuthorId %>.aspx" class="author" target="_blank"><%=CurPost.AuthorName%></a></li>
                        <li>时间：<%=CurPost.PostTime.ToString("HH:mm:ss")%></li>
                    </ul>
                </div>
            </div>
            <div class="comments">
                <div class="title">评论 (共 <em><%=CurPost.CommentCount%></em> 条)</div>
<%
	if (CommentList.PageCount > 0)
	{
%>
				<div class="list">
<%
    	DateTime dt;
		foreach (DataRow row in CommentList.Table.Rows)
		{
			dt = ((DateTime)row["PostTime"]).AddHours(TimeDiff);
%>
                	<div class="comment">
                    	<div class="about">
<%
            if (Convert.ToInt32(row["AuthorId"]) <= 0)
            {
%>
                            网友
<%
            }
            
        	if (String.IsNullOrEmpty(row["Homepage"].ToString()))
        	{
%>
                        	<span><%=row["AuthorName"]%></span>
<%
			}
			else
			{
%>
                        	<a href="http://<%=row["Homepage"]%>" target="_blank"><%=row["AuthorName"]%></a>

<%
        	}
%>
                        	于 <span><%=dt.ToString("yyyy年MM月dd日 HH:mm:ss") %></span> 说：
                    	</div>
                    	<div class="content"><%=row["Content"] %></div>
                	</div>
<%
		}
%>
       			</div>
<%
    	if (CommentList.PageCount > 1)
    	{
%>
                <ol class="pages">
<%
        	if (CommentList.CurrentPage > 1)
        	{
%>
                    <li><a href="ShowComments<%=CurPost.PostId%>-<%=(CommentList.CurrentPage - 1)%>.aspx">&laquo; 上一页</a></li>
<%
        	}
			for (int i = 1; i <= CommentList.PageCount; i++)
			{
				if (CommentList.CurrentPage == i)
				{
%>
                    <li><span><%=i%></span></li>
<%
				}
				else
				{
%>
                    <li><a href="ShowComments<%=CurPost.PostId%>-<%=i%>.aspx"><%=i%></a></li>
<%
				}
			}
        	if (CommentList.CurrentPage < CommentList.PageCount)
        	{
%>
                    <li><a href="ShowComments<%=CurPost.PostId%>-<%=(CommentList.CurrentPage + 1)%>.aspx">下一页 &raquo;</a></li>
<%
        	}
%>
                </ol>
<%
    	}
	}
	else
	{
%>
				<div class="list">
                	<div class="tips">暂无评论</div>
                </div>
<%
	}
%>
            </div>            
            <form id="replyForm" class="commentForm" action="PostComment.aspx" method="post">
                <div class="title">发表评论</div>
            	<table>
                    <tbody>
<%
    if (CurUser == null)
    {
%>
                        <tr>
                            <th><label for="authorName">您的称呼：</label></th>
                            <th><label for="email">您的邮箱：</label></th>
                        </tr>
                        <tr>
                            <td><input type="text" name="authorName" id="authorName" maxlength="30" class="text" style="width: 150px;" /> <em class="required">*</em></td>
                            <td><input type="text" name="email" id="email" maxlength="80" class="text" style="width: 220px;" /> <em class="tips">(保密)</em></td>
                        </tr>
                        <tr>
                        	<th><label for="homePage">您的主页：</label></th>
                            <th></th>
                        </tr>
                        <tr>
                        	<td><input type="text" id="homePage" name="homePage" maxlength="80" class="text" style="width: 220px;" value="http://" /></td>
                            <td></td>
                        </tr>
                        <tr>
                        	<th><label for="content">评论内容：</label></th>
                            <td></td>
                        </tr>
<%
    }
    else
    {
%>
                        <tr>
                            <th colspan="2"><label for="content">以身份 <strong><%=CurUser.UserName%></strong> 发表评论</label></th>
                        </tr>
<%
    }
%>
                        <tr>
                        	<td colspan="2">
                        	    <textarea name="content" id="content" class="text" style="width: 504px; height: 105px; line-height: 21px; vertical-align: bottom;" cols="30" rows="5"></textarea>
                        	    <em class="required">*</em>
                    	            <input type="hidden" name="action" value="post" />
                                    <input type="hidden" id="postId" name="postId" value="<%=CurPost.PostId%>" />　
                                    <input type="submit" class="button" value="提 交" style="vertical-align: bottom;" />
<%
        if (ArticleSetupBLL.Read("AllowComment") == "1")
        {
%>
                    	            <br /><em class="tips">(您发表的评论需通过审核才会显示)</em>
<%
        }
%>
                        	</td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>
        <!--#include file="HtmlInc/SideBar.html"-->
	</div>
</div>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript" src="Js/Message.js"></script>
<script type="text/javascript" src="Js/Comment.js"></script>