﻿<%@ Page Inherits="TidyBlog.Web.ShowIndex" Codebehind="ShowIndex.aspx.cs" %>
<!--#include file="HtmlInc/HtmlBegin.html"-->
<div id="wrapper">
	<div id="subWrapper">
        <div id="main">
            <!--#include file="HtmlInc/Header.html"-->
<%
    if (PostList.PageCount > 0)
    {
%>
            <div id="postList">
<%
    	DateTime dt;
        foreach (DataRow row in PostList.Table.Rows)
        {
            dt = ((DateTime)row["PostTime"]).AddHours(TimeDiff);
%>
                <div class="post">
                    <div class="postHeader">
                        <div class="date"><%=dt.ToString("yy-MM")%> <span class="day"><%=dt.Day%></span></div>
                        <h3><a href="ShowPost<%=row["PostId"]%>.aspx" target="_blank"><%=row["Title"]%></a></h3>
                        <ul>
                            <li>作者：<a href="ShowBlogger<%=row["AuthorId"] %>.aspx" class="author" target="_blank"><%=row["AuthorName"] %></a></li>
                            <li>时间：<%=dt.ToString("yyyy-M-d HH:mm:ss")%></li>
                        </ul>
                    </div>
                    <div class="content"><%=row["Summary"]%></div>
                    <ul class="postFooter">
                        <li class="first"><a href="ShowPost<%=row["PostId"]%>.aspx" target="_blank">阅读全文&gt;&gt;</a></li>
<%
            if (CurUser != null && (CurUser.IsAdmin || CurUser.UserId == Convert.ToInt32(row["AuthorId"])))
            {
%>
                        <li><a href="UpdatePost.aspx?postId=<%=row["PostId"] %>">编辑</a></li>
<%
            }
%>
                        <li>查看次数：<span><%=row["ViewCount"]%></span></li>
                        <li>评论次数：<a href="ShowPost<%=row["PostId"]%>.aspx#comments" target="_blank"><%=row["CommentCount"] %></a></li>
                        <li>分类：<a href="ShowIndex<%=row["CategoryId"]%>.aspx"><%=row["CategoryName"]%></a></li>
                    </ul>
                </div>           
<%
        }
%>
            </div>
<%
        if (PostList.PageCount > 1)
        {
%>
            <ol class="pages">
<%
            string categoryId = CurPosition != null && CurPosition.CategoryId > 0 ? CurPosition.CategoryId.ToString() : String.Empty;
    
            if (PostList.CurrentPage > 1)
            {
%>
                <li><a href="ShowIndex<%=categoryId%>-<%=(PostList.CurrentPage - 1)%>.aspx">&laquo; 上一页</a></li>
<%
            }
            for (int i = 1; i <= PostList.PageCount; i++)
            {
                if (i == PostList.CurrentPage)
                {
%>
                <li><span><%=i%></span></li>
<%
                }
                else
                {
%>
                <li><a href="ShowIndex<%=categoryId%>-<%=i%>.aspx"><%=i%></a></li>
<%
                }
            }
            if (PostList.CurrentPage < PostList.PageCount)
            {
%>
                <li><a href="ShowIndex<%=categoryId%>-<%=(PostList.CurrentPage + 1)%>.aspx">下一页 &raquo;</a></li>
<%
            }
%>
            </ol>
<%
        }
    }
    else
    {
%>
            <div id="message"><p>此分类下暂时没有文章</p></div>
<%
    }
%>
        </div>
        <!--#include file="HtmlInc/SideBar.html"-->
	</div>
</div>
<!--#include file="HtmlInc/Footer.html"-->