﻿<%@ Page Inherits="TidyBlog.Web.UpdatePost" Codebehind="UpdatePost.aspx.cs" %>
<!--#include file="HtmlInc/HtmlBegin.html"-->
<div id="wrapper">
	<div id="subWrapper">
        <div id="main">
            <!--#include file="HtmlInc/Header.html"-->
            <form id="postForm" class="form" action="?action=update&amp;postId=<%=CurPost.PostId%>" method="post" enctype="multipart/form-data">
                <table>
                    <tfoot>
                        <tr>
                            <td colspan="4" class="btns">
                                <input type="submit" value="更 新" class="button" />
                                <input type="reset" value="恢 复" class="button" />
                            </td>
                        </tr>
                    </tfoot>
                    <tbody>
                        <tr>
                            <th><label for="title"><em class="required">*</em> 标题</label></th>
                            <td colspan="3">
                                <input id="title" name="title" type="text" class="text" maxlength="80" style="width: 350px;" value="<%=CurPost.Title%>" />
                                <br /><em class="tips">(2-80个字符)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="keywords">关键字</label></th>
                            <td colspan="3">
                                <input id="keywords" name="keywords" type="text" class="text" maxlength="80" style="width: 320px;" value="<%=CurPost.Keywords%>" />
                                <br /><em class="tips">(80个字符以内，每个关键字之间用英文逗号隔开)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="categoryId"><em class="required">*</em> 所属分类</label></th>
                            <td style="width:35%;">
                                <select id="categoryId" name="categoryId" class="select">
    <%
    foreach (DataRow row in CategoryList.Rows)
    {
    %>
                                    <option value="<%=row["CategoryId"]%>"<% if (Convert.ToInt32(row["CategoryId"]) == CurPost.CategoryId) { %> selected="selected"<% } %>><%=row["CategoryName"]%></option>
    <%
    }
    %>
                                </select>
                            </td>
                            <th><label for="state"><em class="required">*</em> 公开度</label></th>
                            <td style="width: 35%;">
                                <select id="state" name="state" class="select">
                                    <option value="2"<% if (CurPost.State == 2) { %> selected="selected"<% } %>>所有人可查看</option>
                                    <option value="0"<% if (CurPost.State == 0) { %> selected="selected"<% } %>>私有</option>
                                    <option value="1"<% if (CurPost.State == 1) { %> selected="selected"<% } %>>本博客用户可查看</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="summaryLength"><em class="required">*</em> 摘要长度</label></th>
                            <td style="width: 35%;">
                                约
                                <input id="summaryLength" name="summaryLength" class="text" maxlength="4" style="width: 40px;" value="<%=CurPost.SummaryLength > 0 ? CurPost.SummaryLength.ToString() : String.Empty %>"<% if (CurPost.SummaryLength <= 0) { %> readonly="readonly"<% } %> />
                                个字符
                                <input id="isFullSummary" type="checkbox"<% if (CurPost.SummaryLength <= 0) { %> checked="checked"<% } %> />
                                <label for="isFullSummary">内容作为摘要</label>
                            </td>
                            <th><label for="isUpdateTime"><em class="required">*</em> 更新时间</label></th>
                            <td style="width:35%;">
                                <select id="isUpdateTime" name="isUpdateTime" class="select">
                                    <option value="false" selected="selected">否</option>
                                    <option value="true">是</option>
                                </select>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="4">
                            	<iframe src="TidyEditor/TidyEditor.html?id=tidyEditor" frameborder="0" id="tidyEditor" class="tidyEditor" scrolling="no"></iframe>
                                <input id="content" name="content" type="hidden" value="" />
                            </td>
                        </tr>
                        <tr>
                            <th>上传附件</th>
                            <td colspan="3">
                                <ul id="uploadFiles"></ul>
                                <div>添加 <input type="text" id="newFileCount" maxlength="3" value="1" class="text" style="width: 30px;" /> 个文件 <input type="button" value="添 加" class="button" id="addFile" /></div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>
        <!--#include file="HtmlInc/SideBar.html"-->
	</div>
</div>
<div id="oldContent"><!--
<%=CurPost.Content %>
--></div>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript" src="Js/Post.js"></script>