﻿<%@ Page CodeBehind="UpdateUser.aspx.cs" Inherits="TidyBlog.Web.UpdateUser" %>
<!--#include file="HtmlInc/HtmlBegin.html"-->
<div id="wrapper">
	<div id="subWrapper">
        <div id="main">
            <!--#include file="HtmlInc/Header.html"-->
            <form id="userForm" class="form" action="?action=update" method="post" enctype="multipart/form-data">
                <table>
                    <tfoot>
                        <tr>
                            <td colspan="2" class="btns">
                                <input type="submit" class="button" value="更 新" />
                                <input type="reset" class="button" value="恢 复" />
                            </td>
                        </tr>
                    </tfoot>
                    <tbody>
                        <tr>
                            <th><label for="password">密　　码</label></th>
                            <td>
                                <input type="password" id="password" name="password" maxlength="16" class="text" style="width: 140px;" />
                                <em class="tips">(6-16个字符，不改请留空)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="password2">重复密码</label></th>
                            <td>
                                <input type="password" id="password2" maxlength="16" class="text" style="width: 140px;" />
                                <em class="tips">(重复一次上面输入的密码)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="trueName">真实姓名</label></th>
                            <td>
                                <input type="text" name="trueName" id="trueName" maxlength="30" class="text" style="width: 120px;" value="<%=CurUser.TrueName%>" />
                                <em class="tips">(30个字以内)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="dateOfBirth">出生年月</label></th>
                            <td>
                                <input type="text" name="dateOfBirth" id="dateOfBirth" maxlength="7" class="text" style="width:6em;" value="<%=CurUser.DateOfBirth%>" />
                                <em class="tips">(格式“年-月”，例如“2008-7”)</em>
                            </td>
                        </tr>
                        <tr>
        	                <th><em class="required">*</em> 性　别</th>
                            <td>
            	                <input type="radio" name="gender" value="true"<% if (CurUser.Gender) { %> checked="checked"<% } %> /> 男
                                <input type="radio" name="gender" value="false"<% if (!CurUser.Gender) { %> checked="checked"<% } %> /> 女
                            </td>
                        </tr>
                        <tr>
                            <th><label for="headUrlType"><em class="required">*</em> 头像地址</label></th>
                            <td>
                                <select name="headUrlType" id="headUrlType" class="select">
                    	            <option value="0" selected="selected">不修改</option>
                    	            <option value="1">Url</option>
                                    <option value="2">上传</option>
                                    <option value="3">恢复默认头像</option>
                                </select>
                                <input type="file" name="headUpload" id="headUpload" class="text" style="display: none;" />
                                <input type="text" name="wwwUrl" id="wwwUrl" maxlength="80" class="text" style="width: 300px; display: none;" />
                                <input type="hidden" name="oldUrl" value="<%=CurUser.HeadUrl%>" />
                            </td>
                        </tr>
                        <tr>
                            <th><label for="email">电子邮件</label></th>
                            <td>
                                <input type="text" name="email" id="email" maxlength="80" class="text" style="width: 250px;" value="<%=CurUser.Email%>" />
                                <em class="tips">(80个字以内)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="qq">QQ 号码</label></th>
                            <td>
                                <input type="text" name="qq" id="qq" maxlength="20" class="text" style="width: 150px;" value="<%=CurUser.QQ%>" />
                                <em class="tips">(20个数字以内)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="homePage">个人主页</label></th>
                            <td>
                                <input type="text" name="homePage" id="homePage" class="text" maxlength="80" style="width: 200px;" value="<%=CurUser.HomePage%>" />
                                <em class="tips">(80个字以内)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="hometown">来自</label></th>
                            <td>
                                <input type="text" name="hometown" id="hometown" class="text" maxlength="30" style="width: 120px;" value="<%=CurUser.Hometown%>" />
                                <em class="tips">(30个字以内)</em>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="interests">个人兴趣</label></th>
                            <td>
                                <textarea rows="5" cols="80" name="interests" id="interests" class="text" style="width: 450px; height: 80px;"><%=CurUser.Interests%></textarea>
                            </td>
                        </tr>
                        <tr>
                            <th><label for="introduction">个人简介</label></th>
                            <td>
                                <textarea rows="5" cols="80" name="introduction" id="introduction" class="text" style="width: 450px; height: 80px;"><%=CurUser.Introduction%></textarea>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </form>
        </div>
        <!--#include file="HtmlInc/SideBar.html"-->
	</div>
</div>
<!--#include file="HtmlInc/Footer.html"-->
<script type="text/javascript" src="Js/User.js"></script>
