﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using blog.Models;
using System.Xml;
using System.Xml.Linq;
using System.Data.SqlClient;
namespace blog.Controllers
{
    [HandleError]
    public class HomeController : Controller
    {
        cms db = new cms();
        public ActionResult Index(string id)
        {
           
            IQueryable<news> n = db.news.OrderByDescending(d=>d.ndate);
            if (id.Contains("t"))
            {
                n = from d in db.news
                    where (d.tag + " ").Contains(id.Substring(1) + "")
                    orderby d.ndate descending 
                    select d;
                
            }
            else if (id.Contains("c"))
            {
                n = from d in db.news
                    where d.cid == Convert.ToInt32(id.Substring(1))
                    orderby d.ndate descending 
                    select d;
                
            }
            else if (id.Contains("d"))
            {
                var s =id.Substring(1).Split('-');
                n = from d in db.news
                    where Convert.ToDateTime(d.ndate).Month.ToString() == s[1]
                    && Convert.ToDateTime(d.ndate).Year.ToString() == s[0]
                    orderby d.ndate descending 
                    select d;
               
            }

         
            
           
            if (Request["page"]!=null)
            {

                ViewData["page"] = SqlHelper.Pager(Request.RawUrl.Substring(0, Request.RawUrl.IndexOf("?")), Convert.ToInt32(Request["page"]), n.Count(), 5, 3);
                 n = n.Skip((Convert.ToInt32(Request["page"]) - 1) * 5).Take(5);

            }
            else
            {
                ViewData["page"] = SqlHelper.Pager(Request.RawUrl, 1, n.Count(), 5, 3);

                n = n.Skip(0).Take(5);
            }



            return View(n);
        }

        public ActionResult Archive()
        {
            List<dang> n = new List<dang>();
             SqlDataReader dr = SqlHelper.ExecuteReader(SqlHelper.conn, System.Data.CommandType.Text, "select max(ndate),count(ndate) from news group by year(ndate),month(ndate) order by  max(ndate) desc");
            while (dr.Read())
            {
                dang d1 = new dang();
                d1.name = Convert.ToDateTime(dr[0]).ToString("yyyy年MM月");
                d1.sum = Convert.ToInt32(dr[1]);
                d1.id = Convert.ToDateTime(dr[0]).Year.ToString() + "-" + Convert.ToDateTime(dr[0]).Month.ToString();
                n.Add(d1);
            }
            return View(n);
        }
        public ActionResult Tag()
        {
           var t = from d in db.tag
                orderby d.sum descending
                select d;
            return View(t);
        }
        public PartialViewResult aa()
        {
            ViewData["a"] = "王继坤";
           
            return PartialView("aa","cc");
             
        }
        public ActionResult Search()
        {
            if (Request["s"] != null)
            { 
               var n = from d in db.news
                    where d.title.Contains(Request["s"].ToString())
                    select d;
               int size = 5;
                if (Request["page"] != null)
                {
                   
                    int p = Convert.ToInt32(Request["page"]);
                    ViewData["page"] = SqlHelper.Pager(Request.RawUrl.Substring(0, Request.RawUrl.IndexOf("?")),p, n.Count(),size, 3);

                    n = n.OrderByDescending(d => d.ndate).Skip((p - 1) * size).Take(size);
                }
                else
                {
                    ViewData["page"] = SqlHelper.Pager(Request.RawUrl, 1, n.Count(), size, 3);
                    n = n.OrderByDescending(d => d.ndate).Skip(0).Take(size);
                }
                return View(n);
            }
            return View();
        }

        public ActionResult About()
        {
            ViewData["dd"] = "ddd";
            return View();
        }
        public ActionResult show(int id)
        {
            var n1 = db.news.Where(d => d.nid == id);
            if(n1.Count()>0)
            return View(n1.First());
            return View();
        }
        public ActionResult rss()
        { 
            
            
            var sq = db.news.OrderBy(d => d.ndate).Skip(0).Take(20).ToList();
        
        
        XElement contacts = new XElement("rss", new XAttribute("version", "2.0"),
                  new XAttribute(XNamespace.Xmlns+"blogChannel", "http://backend.userland.com/blogChannelModule"),
                   new XAttribute(XNamespace.Xmlns+"dc", "http://purl.org/dc/elements/1.1/"),
                  new XAttribute(XNamespace.Xmlns+"pingback", "http://madskills.com/public/xml/rss/module/pingback/"),
                   new XAttribute(XNamespace.Xmlns+"trackback", "http://madskills.com/public/xml/rss/module/trackback/"),
                   new XAttribute(XNamespace.Xmlns+"wfw", "http://wellformedweb.org/CommentAPI/"),
                   new XAttribute(XNamespace.Xmlns+"slash", "http://purl.org/rss/1.0/modules/slash/"),
                   new XAttribute(XNamespace.Xmlns+"geo", "http://www.w3.org/2003/01/geo/wgs84_pos#"),

 
                  new XElement("channel",

                       new XElement("title", "wjk3个人网址Rss"),

                       new XElement("link", "http://www.wjk3.cn"),

                       new XElement("description", "C#,linq,vs2008,wjk3"),

                       new XElement("language", "zh_cn"),

                       new XElement("copyright", "Copyright 2008 wjk3.cn"),

                       new XElement("webMaster", "wangjikun3@163.com")));

        //这里开始循环写数据

        foreach (var p in sq)
        {

            contacts.Element("channel").Add(new XElement("item",

                             new XElement("title", p.title),

                             new XElement("link", "/home/show/" + p.nid),

                             new XElement("description", p.cont),

                             new XElement("category", p.cls.name),

                             new XElement("pubDate", p.ndate)));

        }






        return Content(contacts.ToString());

        }
        
    }
}
