using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Mvc.Ajax;
using blog.Models;
namespace blog.Controllers
{
    public class NewsController : Controller
    {
        //
        // GET: /News/
        cms db = new cms();
        private List<cls> droplist()
        {
            var d1 = db.cls.OrderBy(d => d.demo);
            List<cls> d2 = new List<cls>();
            foreach (var d in d1)
            {
                cls d3 = new cls();
                d3.cid = d.cid;
                string k = "";
                for (var i = 0; i < d.demo.Length / 2 - 1; i++)
                {
                    k += "";
                }
                d3.name = k + d.name;

                d2.Add(d3);
            }
            return d2;
        }
        [Authorize]
        public ActionResult Index(string drop, string page)
        {

            var d2 = droplist();
            ViewData["drop"] = new SelectList(d2, "cid", "name");


            var n = from d in db.news
                    select d;
            if (drop != null)
            {
                n = from d in n
                    where d.cid == Convert.ToInt32(drop)
                    select d;
            }
            n = n.OrderByDescending(d => d.ndate);
            int size = 10;
            if (page != null)
            {
                ViewData["page"] = SqlHelper.Pager(Request.RawUrl.Substring(0, Request.RawUrl.IndexOf("?")), Convert.ToInt32(page), n.Count(), size, 3);
                n = n.Skip((Convert.ToInt32(Request["page"]) - 1) * size).Take(size);
            }
            else
            {
                ViewData["page"] = SqlHelper.Pager(Request.RawUrl, 1, n.Count(), size, 3);
                n = n.Skip((1 - 1) * size).Take(size);
            }
            return View(n);
        }

        //
        // GET: /News/Details/5
        [Authorize]
        public ActionResult delete(int id)
        {
            var n = db.news.First(d => d.nid == id);
            db.news.DeleteOnSubmit(n);
            db.SubmitChanges();
            return RedirectToAction("index");
        }

        //
        // GET: /News/Create
        [Authorize]
        public ActionResult Create()
        {
            var d2 = droplist();
            ViewData["cid"] = new SelectList(d2, "cid", "name");
            news d = new news();
            return View(d);
        } 

        //
        // POST: /News/Create
        [Authorize]
        [ValidateInput(false)]
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Create(news n)
        {
            n.nid = SqlHelper.get_ID("news", "nid");
            n.uid = 1;
            n.pic = "";
            n.ndate = DateTime.Now;
            db.news.InsertOnSubmit(n);
             
            db.SubmitChanges();
            string[] tags = n.tag.Split(',');
            foreach (var t in tags)
            {
                var t2 = db.tag.Where(d => d.name == t);
                if (t2.Count() == 0)
                {
                    tag tag1 = new tag();
                    tag1.name = t;
                    tag1.tid = SqlHelper.get_ID("tag", "tid");
                    tag1.sum = 1;
                    db.tag.InsertOnSubmit(tag1);
                }
                else
                {
                    var t3 = t2.First();
                    t3.sum += 1;
                }
                db.SubmitChanges();
            }
            

           
            var d2 = droplist();
            ViewData["cid"] = new SelectList(d2, "cid", "name");
           
            return View();
        }

        //
        // GET: /News/Edit/5
        [Authorize]
        public ActionResult Edit(int id)
        {
            var d2 = droplist();
           
            var n = db.news.First(d => d.nid == id);
            ViewData["cid"] = new SelectList(d2, "cid", "name",n.cid);
            return View(n);
        }

        //
        // POST: /News/Edit/5
        [Authorize]
        [AcceptVerbs(HttpVerbs.Post)]
        [ValidateInput(false)]
        public ActionResult Edit(int id, news n)
        {
            try
            {
                // TODO: Add update logic here

                var n1 = db.news.First(d => d.nid == id);
                var t4 = n1.tag;
                UpdateModel(n1, new[] {"title","cid","cont","summary","tag"});
                string[] tags = n1.tag.Split(',');
                foreach (var t in tags)
                {
                    var t2 = db.tag.Where(d => d.name == t);
                    if (t2.Count() == 0)
                    {
                        tag tag1 = new tag();
                        tag1.name = t;
                        tag1.tid = SqlHelper.get_ID("tag", "tid");
                        tag1.sum = 1;
                        db.tag.InsertOnSubmit(tag1);
                    }
                    else if(!t4.Contains(t))
                    {
                        var t3 = t2.First();
                        t3.sum += 1;
                    }
                }
                db.SubmitChanges();
                return RedirectToAction("Index");
            }
            catch
            {
                return View();
            }
        }
    }
}
