﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using OMCS.Passive;
using System.Configuration;
using ESPlus.Rapid;
using ESPlus.Application.Basic;
using ESPlus.Application.CustomizeInfo.Passive;
using ESBasic.Security;
using System.Security.Cryptography;
using ESPlus.Application.CustomizeInfo;
using OMCS.Tools;

using System.Diagnostics;
using ESFramework.Boost.DynamicGroup.Passive;
using ESFramework.Boost.NetworkDisk.Passive;

namespace OVCS
{
    public partial class LoginForm : Form
    {
        #region RapidPassiveEngine
        private IRapidPassiveEngine rapidPassiveEngine = RapidEngineFactory.CreatePassiveEngine();

        public IRapidPassiveEngine RapidPassiveEngine
        {
            get { return rapidPassiveEngine; }
        } 
        #endregion

        #region UserID
        private string userID;
        public string UserID
        {
            get { return userID; }
        }
        #endregion

        #region RoomID
        private string roomID;
        public string RoomID
        {
            get { return roomID; }
        }
        #endregion

        #region MultimediaManager
        private IMultimediaManager multimediaManager = MultimediaManagerFactory.GetSingleton();
        public IMultimediaManager MultimediaManager
        {
            get { return multimediaManager; }
        } 
        #endregion     

        #region GroupOutter
        private DynamicGroupOutter groupOutter = new DynamicGroupOutter();
        public DynamicGroupOutter GroupOutter
        {
            get { return groupOutter; }
        }
        #endregion       
        
        private CustomizeHandler customizeHandler;       
        private string password = "";
        public LoginForm(CustomizeHandler _customizeHandler)
        {
            InitializeComponent();        
            this.customizeHandler = _customizeHandler;    
        }
       

        private void button2_Click(object sender, EventArgs e)
        {
            try
            {
                this.roomID = this.textBox_roomID.Text.Trim();
                if (this.textBox_userID.Text.Trim() == "")
                {
                    return;
                }
                this.userID = this.textBox_userID.Text;                 
                if (this.userID.Length > 11)
                {
                    MessageBox.Show("登录账号的长度不能超过11");
                    return;
                }

                this.password = this.textBox_password.Text.Trim();

                this.label_state.Visible = true;
                this.Cursor = Cursors.WaitCursor;
                this.Refresh();
                if (!this.Login())
                {
                    this.label_state.Visible = false;
                    this.Cursor = Cursors.Default;
                    this.Refresh();
                    return;
                }                
                this.DialogResult = System.Windows.Forms.DialogResult.OK;
            }
            catch (Exception ee)
            {
                this.label_state.Visible = false;
                this.Cursor = Cursors.Default;
                MessageBox.Show(ee.Message);
                Program.Logger.Log(ee, "LoginForm.button2_Click登录的处理", ESBasic.Loggers.ErrorLevel.High);
            }
        }

        private bool Login()
        {       
            //业务逻辑服务器
            this.rapidPassiveEngine.WaitResponseTimeoutInSecs = 30;
            this.rapidPassiveEngine.HeartBeatSpanInSecs = 5;
            this.rapidPassiveEngine.SecurityLogEnabled = false;            
            
            groupOutter.TryP2PWhenGroupmateConnected = false;
            groupOutter.RapidPassiveEngine = this.rapidPassiveEngine;
            DynamicGroupPassiveHandler groupPassiveHandler = new DynamicGroupPassiveHandler();
            groupPassiveHandler.Initialize(groupOutter);

            NDiskPassiveHandler nDiskPassiveHandler = new NDiskPassiveHandler();

            ComplexCustomizeHandler handler = new ComplexCustomizeHandler(this.customizeHandler, groupPassiveHandler, nDiskPassiveHandler);           
            LogonResponse result = this.rapidPassiveEngine.Initialize(this.userID, this.password, ConfigurationManager.AppSettings["ServerIP"], int.Parse(ConfigurationManager.AppSettings["ServerPort"]), handler);
           
            if (result.LogonResult != LogonResult.Succeed)
            {
                if (result.LogonResult == LogonResult.HadLoggedOn)
                {
                    MessageBox.Show("已经在其它地方登录！");
                }
                else
                {
                    MessageBox.Show("用户或者密码错误！");
                }
                return false;
            }
           
            groupOutter.Initialize(this.rapidPassiveEngine.CurrentUserID);
            nDiskPassiveHandler.Initialize(this.rapidPassiveEngine.FileOutter, null);

            //OMCS 参数设置            
            multimediaManager.AutoReconnect = false;
            multimediaManager.SecurityLogEnabled = true;        
            multimediaManager.AutoAdjustCameraEncodeQuality = false;
            multimediaManager.CameraDeviceIndex = 0;
            multimediaManager.CameraEncodeQuality = 10;
            multimediaManager.MaxCameraFrameRate = 12;
            multimediaManager.DesktopEncodeQuality = 10;
            multimediaManager.MaxDesktopFrameRate = 3;           
            multimediaManager.Advanced.AllowDiscardFrameWhenBroadcast = false;
            multimediaManager.Advanced.MaxInterval4CameraKeyFrame = 20;
            multimediaManager.Advanced.MaxInterval4DesktopKeyFrame = 20;                      
           
            try
            {
                string[] cameraSizeStr = ConfigurationManager.AppSettings["CameraVideoSize"].Split(',');
                multimediaManager.CameraVideoSize = new System.Drawing.Size(int.Parse(cameraSizeStr[0]), int.Parse(cameraSizeStr[1]));
            }
            catch { }
               
            multimediaManager.Initialize(userID, "", ConfigurationManager.AppSettings["ServerIP"], int.Parse(ConfigurationManager.AppSettings["OmcsPort"]));
            multimediaManager.OutputAudio = true;          
           
            return true;
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process.Start("http://www.cnblogs.com/justnow");
        }
    }
    
}
