﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ESBasic;
using ESFramework.Server;
using ESFramework.Server.UserManagement;
using ESPlus.Rapid;
using OMCS.Server;

namespace OVCS.Server
{
    public partial class MainServerForm : Form
    {
        private IMultimediaServer multimediaServer;
        private IRapidServerEngine rapidServerEngine;
        private System.Threading.Timer timer;

        public MainServerForm(IRapidServerEngine engine , IMultimediaServer server)
        {
            InitializeComponent();
            this.TextChanged += new EventHandler(ServerForm_TextChanged);

            this.rapidServerEngine = engine;
            this.multimediaServer = server;
            this.rapidServerEngine.UserManager.SomeOneConnected += new CbGeneric<UserData>(multimediaServer_UserConnected);
            this.rapidServerEngine.UserManager.SomeOneDisconnected += new CbGeneric<UserData, DisconnectedType>(multimediaServer_UserDisconnected);
            this.label_time.Text = DateTime.Now.ToString();
            this.label_esfPort.Text = this.rapidServerEngine.Port.ToString();
            this.label_omcsPort.Text = this.multimediaServer.Port.ToString();

            this.timer = new System.Threading.Timer(this.Callback, null, 1000, 1000);
        }

        void ServerForm_TextChanged(object sender, EventArgs e)
        {
            this.notifyIcon1.Text = this.Text;
        }

        void multimediaServer_UserDisconnected(UserData user , DisconnectedType type)
        {
            if (this.InvokeRequired)
            {
                this.BeginInvoke(new CbGeneric<UserData , DisconnectedType>(this.multimediaServer_UserDisconnected), user, type);
            }
            else
            {
                this.label_userCount.Text = this.rapidServerEngine.UserManager.UserCount.ToString();
                this.toolStripLabel_msg.Text = string.Format("{0} 下线。{1}", user.UserID, DateTime.Now.ToString());
            }
        }

        void multimediaServer_UserConnected(UserData user)
        {
            if (this.InvokeRequired)
            {
                this.BeginInvoke(new CbGeneric<UserData>(this.multimediaServer_UserConnected), user);
            }
            else
            {
                this.label_userCount.Text = this.rapidServerEngine.UserManager.UserCount.ToString();
                this.toolStripLabel_msg.Text = string.Format("{0} 上线。{1}", user.UserID, DateTime.Now.ToString());
            }
        }

        private void Callback(object state)
        {
            if (this.InvokeRequired)
            {
                this.BeginInvoke(new CbGeneric<object>(this.Callback), state);
            }
            else
            {
                this.label_userCount.Text = this.rapidServerEngine.UserManager.UserCount.ToString();
            }
        }

        private bool toClose = false;
        private void 退出ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (!ESBasic.Helpers.WindowsHelper.ShowQuery("您确定要退出OVCS服务器吗？"))
            {
                return;
            }

            this.toClose = true;
            this.Close();

        }

        private void ServerForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!this.toClose)
            {
                e.Cancel = true;
                this.Visible = false;
                return;
            }

            this.rapidServerEngine.Close();
            this.multimediaServer.Close();
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            this.Visible = !this.Visible;
        }        
    }
}
