﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using ESPlus.Rapid;
using System.Configuration;
using ESPlus.Application.Group.Server;
using ESPlus.Application.Group;
using ESPlus.Core;
using ESPlus.Application.CustomizeInfo;
using ESFramework.Boost.DynamicGroup.Server;
using ESFramework.Boost.NetworkDisk.Server;

namespace OVCS.Server
{
    static class Program
    {
        static IRapidServerEngine RapidServerEngine = RapidEngineFactory.CreateServerEngine();
        static OMCS.Server.IMultimediaServer MultimediaServer;        
       
        /// <summary>
        /// 应用程序的主入口点。
        /// </summary>
        [STAThread]
        static void Main()
        {
            try
            {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);

                //ESPlus.GlobalUtil.SetMaxLengthOfUserID(20);
                //OMCS.GlobalUtil.SetMaxLengthOfUserID(20);
                ESPlus.GlobalUtil.SetAuthorizedUser("FreeUser", "");                
                OMCS.GlobalUtil.SetAuthorizedUser("FreeUser", "");

                DynamicGroupManager dynamicGroupManager = new DynamicGroupManager();//视频会议房间管理、即动态组管理
                Program.RapidServerEngine.UseAsP2PServer = true;
                Program.RapidServerEngine.GroupManager = dynamicGroupManager;
                CustomizeInfoHandler customizeInfoHandler = new CustomizeInfoHandler();               
                DynamicGroupHandler groupHandler = new DynamicGroupHandler();
                NDiskHandler nDiskHandler = new NDiskHandler();

                ComplexCustomizeHandler complexHandler = new ComplexCustomizeHandler(customizeInfoHandler, groupHandler, nDiskHandler);
                Program.RapidServerEngine.Initialize(int.Parse(ConfigurationManager.AppSettings["Port"]), complexHandler);
                Program.RapidServerEngine.GroupController.GroupNotifyEnabled = true;
                Program.RapidServerEngine.UserManager.RelogonMode = ESFramework.Server.UserManagement.RelogonMode.IgnoreNew;               
                groupHandler.Initialize(Program.RapidServerEngine.UserManager, Program.RapidServerEngine.CustomizeController, dynamicGroupManager);
                NetworkDisk networkDisk = new NetworkDisk(new NDiskPathManager(), Program.RapidServerEngine.FileController);
                nDiskHandler.Initialize(Program.RapidServerEngine.FileController, networkDisk);

                #region OMCS 服务器设置
                
                OMCS.OMCSConfiguration config = new OMCS.OMCSConfiguration();

                //用于验证登录用户的帐密
                OMCS.Server.DefaultUserVerifier userVerifier = new OMCS.Server.DefaultUserVerifier();
                Program.MultimediaServer = OMCS.Server.MultimediaServerFactory.CreateMultimediaServer(int.Parse(ConfigurationManager.AppSettings["OmcsPort"]), userVerifier, config,false);                             
                #endregion

                MainServerForm form = new MainServerForm(Program.RapidServerEngine ,Program.MultimediaServer);               
                Application.Run(form);
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
            }
        }
    }
}
