﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Web.Caching;
//该源码下载自www.51aspx.com(５１ａｓｐｘ．ｃｏｍ)
namespace Utility
{
    public class Caching
    {
        /// <summary>
        /// 获取指定的缓存
        /// </summary>
        /// <param name="name"></param>
        /// <returns></returns>
        public static object Get(string name)
        {
            return System.Web.HttpContext.Current.Cache.Get(name);
        }

        /// <summary>
        /// 删除指定的缓存
        /// </summary>
        /// <param name="name"></param>
        public static void Remove(string name)
        {
            System.Web.HttpContext.Current.Cache.Remove(name);
        }

        /// <summary>
        /// 设置Cache的值
        /// </summary>
        /// <param name="name">Cookie的名称</param>
        /// <param name="objValue">Cache的值</param>
        /// <param name="cacheName"></param>
        public static void Set(string name, object objValue, CacheDependency cacheName)
        {
            System.Web.HttpContext.Current.Cache.Insert(name, objValue, cacheName, Cache.NoAbsoluteExpiration, TimeSpan.FromMinutes(15));
        }
    }
}
//5_1_a_s_p_x.c_o_m
