﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using mymvc.Models;

namespace mymvc.Controllers
{
    [HandleError]
    public class HomeController : Controller
    {
        private mymvc.Models.MyMvcEntities db = new Models.MyMvcEntities();
        public ActionResult Index()
        {
            List<Models.Columns> col = (from m in db.Columns select m).ToList();
            var NewUser = (from m in db.Member orderby m.Id descending select m).First();
            ViewData["NewUser"] = NewUser.UserName;
            ViewData["MemberCount"] = db.Member.Count();
            //var a = db.GuestBook.Where(e => e.G_Recycle == 1);

            ViewData["CommentCount"] = db.Comment.Count(e => e.GuestBook.G_Recycle == 1);// a.Sum(e => e.Comment.Count());
            ViewData["GuestBookCount"] = db.GuestBook.Count(e => e.G_Recycle == 1);
            return View(col);
        }

        public ActionResult Show(int? id, int? Page)
        {
            //List<Models.GuestBook> bookss = (from m in db.GuestBook where m.G_Recycle == 1 && m.Column_Id == id orderby m.Id descending select m).ToList();
            var col = db.Columns.FirstOrDefault(e => e.Id == id);
            if (col == null)
            {
                ViewData["Message"] = "不存在该栏目!";
                ViewData["Message1"] = "主页面";
                ViewData["Url"] = "/Home/Index";
                return View("Message");
            }
            int PageSize = 10;
            int PageIndex = Page ?? 1;
            if (PageIndex < 1) PageIndex = 1;
            var list = db.GuestBook.Where(e => e.G_Recycle == 1 && e.Column_Id == id).OrderByDescending(e => e.Id);
            ViewData["PageIndex"] = PageIndex;
            ViewData["PageSize"] = PageSize;
            ViewData["ReCordCount"] = list.Count();

            //ViewData["ColumnName"] = bookss.First().Columns.Column_Name;
            ViewData["ColumnName"] = col;
            return View(FPage.GetPageList(list, PageIndex, PageSize));
        }
        public ActionResult Create()
        {
            IEnumerable<Models.Columns> col = from m in db.Columns select m;
            ViewData["PList"] = col.Select(e => new SelectListItem() { Text = e.Column_Name, Value = e.Id.ToString() });
            if (Session["username"] == null)
            { return RedirectToAction("Login","Member"); }
            return View();
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Create(Models.GuestBook gb, string G_Content)
        {
            IEnumerable<Models.Columns> col = from m in db.Columns select m;
            ViewData["PList"] = col.Select(e => new SelectListItem() { Text = e.Column_Name, Value = e.Id.ToString() });
            if (!ModelState.IsValid)
                return View();
            if (string.IsNullOrEmpty(gb.G_Title))
            {
                ModelState.AddModelError("G_Title", "标题不得为空！");
                return View();
            }
            if (string.IsNullOrEmpty(G_Content))
            {
                ModelState.AddModelError("G_content", "留言内容不得为空！");
                return View();
            }
            if (gb.G_Content.Length > 375)
            {
                ModelState.AddModelError("G_content", "留言数量不得大于375字！");
                return View();
            }
            if (Request.Form["YanZheng"].ToUpper() != Session["GoogleCode"].ToString())
            {
                ModelState.AddModelError("YanZhengError", "验证码错误！");
                return View();
            }

            

            gb.MemberId = (int)Session["UID"];
            gb.G_Time = DateTime.Now;
            gb.G_Recycle = 1;
            
            db.AddToGuestBook(gb);
            
            db.SaveChanges();
            return RedirectToAction("Index");

        }

        public ActionResult LogOff()
        {
            Session["User_qx"] = null;
            Session["UID"] = null;
            Session["username"] = null;
            return RedirectToAction("Index");
        }

        public ActionResult Delete(int id)
        {

            if (!Check.CheckPower(this.ControllerContext)) return View("Message");

            Models.GuestBook gb = (from m in db.GuestBook where m.Id == id select m).First();
            if (!ModelState.IsValid)
                return View(gb);
            gb.G_Recycle = 2;            
            db.SaveChanges();
            ViewData["Message"] = "该留言已被删除到回收站!";
            ViewData["Message1"] = "留言管理页面";
            ViewData["Url"] = "/Admin/Admin_GBook";
            return View("Message");
        }

        public ActionResult HuiFu(int id)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            Models.GuestBook gb = (from m in db.GuestBook where m.Id == id select m).First();
            return View(gb);
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult HuiFu(int Id, string G_HF_Content)
        {
            Models.GuestBook gbook = (from m in db.GuestBook where m.Id == Id select m).First();
            if (string.IsNullOrEmpty(G_HF_Content))
            {
                ModelState.AddModelError("G_HF_Content", "回复内容不得为空！");
                return View(gbook);
            }
            if (G_HF_Content.Length > 375)
            {
                ModelState.AddModelError("G_HF_Content", "回复内容不得大于375字！");
                return View(gbook);
            }
            if (!ModelState.IsValid)
                return View(gbook);
            gbook.G_HF_Content = G_HF_Content;
            
            db.SaveChanges();
            ViewData["Message"] = "该留言回复成功!";
            ViewData["Message1"] = "主页面";
            ViewData["Url"] = "/Home/Index";
            return View("Message");
        }

         
    }
}
