﻿var AlbumViewer = {
	film: null,
	pictures: [],
	already: 0,
	rollStep: 0,
	current: null,
	initialize: function() {
		window.setInterval(this.roll.bind(this), 30);
		document.attachEvent("onmouseup", this.abort.bind(this));
	},
	previous: function() {
		this.rollStep = 8;
	},
	next: function() {
		this.rollStep = -8;
	},
	abort: function() {
		this.rollStep = 0;
	},
	roll: function() {
		try {
			this.film.scrollLeft -= this.rollStep;
			if(this.rollStep < 0) {
			    this.checkNever();
			}
		}
		catch(ex) {
		}
	},
	checkNever: function() {
	    if(this.film.scrollWidth - this.film.scrollLeft < this.film.offsetWidth * 1.5) {
	        this.appendNextPicture(this);
	    }
	},
	appendNextPicture: function() {
	    if(this.already < this.pictures.length) {
	        var t = this.film.firstChild;
	        var cell = document.createElement('td');
	        t.rows[0].appendChild(cell);
	        var content = ['<a href="#" onclick="return false"><img alt="'];
	        content.push(this.pictures[this.already].description.replace(/&apos;/gi, "'"));
	        content.push('" src="');
		    content.push('album/thumb/');
		    content.push(this.pictures[this.already++].src);
		    content.push('" /></a>');
		    cell.innerHTML = content.join('');
	        return true;
	    }
	    return false;
	},
	show: function(id,name,pics) {
	    this.already = 0;
	    this.pictures = pics;
	    var already = Math.min(pics.length,6);
		this.showComment(id);
		this.film = $id('syblog_album_film_content');
		this.photo = $id('syblog_album_photo');
		
		this.film.innerHTML = '<table border="0" cellpadding="0" cellspacing="5"><tr></tr></table>';
		
		for(var i = 0;i < already;i++) {
		    this.appendNextPicture();
		}
		
		this.film.scrollLeft = 0;
		(this.current = this.film.firstChild.rows[0].cells[0]).className = "selected";

		$id('syblog_album_photo_title').innerText = pics[0].description.length > 0 ? pics[0].description.replace(/&quot;/gi, '"').replace(/&apos;/gi, "'") : pics[0].src;
		this.photo.innerHTML = '<img border="0" src="album/' + pics[0].src + '" />';
		$id('syblog_album_title').innerText = name;
		$id('syblog_album_viewer').style.display='block';
		$id('syblog_album_list').style.display='none';
		this.film.onclick = function() {
			if(event.srcElement.tagName.toLowerCase() == "img") {
				this.current.className = "";
				this.current = event.srcElement.parentNode.parentNode;
				this.current.className = "selected";
				this.film.scrollLeft = this.current.offsetLeft - this.film.offsetWidth / 2 + this.current.offsetWidth / 2;
				this.photo.innerHTML = '<img border="0" src="' + event.srcElement.src.replace(/\/album\/thumb\//gi,"/album/") + '" />';
				var alt = event.srcElement.getAttribute('alt');
				$id('syblog_album_photo_title').innerText = alt.length > 0 ? alt.replace(/&apos;/gi, "'") : decodeURI(this.photo.firstChild.src.replace(/.*\/album\/(.*)/gi,"$1"));
				this.checkNever();
			}
		}.bind(this);
		this.film.previousSibling.onmousedown = this.previous.bind(this);
		this.film.previousSibling.onmouseout = this.abort.bind(this);
		this.film.nextSibling.onmousedown = this.next.bind(this);
		this.film.nextSibling.onmouseout = this.abort.bind(this);
	},
	showComment: function(id) {
		var xmlhttp = new HTTPRequest();
		xmlhttp.send("AlbumStat.aspx?id=" + id,null,function(r) {
			var stats = r.getXML().documentElement.selectSingleNode("table/row");
			$("sycode_album_createtime").innerHTML = stats.selectSingleNode("createdate").text;
			$("sycode_album_view").innerHTML = stats.selectSingleNode("viewcount").text;
			var cc = $("sycode_album_comment").innerHTML = stats.selectSingleNode("comment").text;
			if(cc > 0) {
				var pc = Math.ceil(cc / 30);
				AlbumViewer.commentPage(id, pc, pc);
			}
			else {
				$("sycode_topic_comment").firstChild.nextSibling.innerHTML = "";
				$("sycode_topic_comment").lastChild.style.display = "none";
			}
		});
	},
	commentPage: function(album, page, max, roll) {
		if(!window.docs.commentXsl) {
			var xmlhttp = new HTTPRequest();
			xmlhttp.send("ui/common/comment.xsl",null,function(r) {
				window.docs.commentXsl = r.getXML();
				AlbumViewer.commentPage(album, page, max);
			});
		}
		else {
			var xmlhttp = new HTTPRequest();
			xmlhttp.send("album/comment/" + album + "/" + page + ".xml",null,function(r) {
				if(roll) {
					if(window.isIE) {
						$id("syblog_body").scrollTop += $("sycode_topic_comment").getPosition().y;
					} else  {
						$id("syblog_body").scrollTop = $("sycode_topic_comment").getPosition().y;
					}
				}
				$("sycode_topic_comment").firstChild.nextSibling.innerHTML = r.getXML().transformNode(window.docs.commentXsl.documentElement).replace(/_src="/gmi, 'src="');
			});
			
			if(max > 1) {
				var start = Math.max(page - 5, 1);
				var end = Math.min(start + 5,max);
				function appendItem(pager, p, txt) {
					pager.push('<a href="#" onclick="AlbumViewer.commentPage(\'');
					pager.push(album);
					pager.push("',");
					pager.push(p);
					pager.push(',');
					pager.push(max);
					pager.push(',true);return false;">');
					pager.push(txt);
					pager.push('</a>');
				}
				var pager = [];
				if(page > 1) {
					appendItem(pager, page - 1, "上一页");
				}
				for(var i = start;i <= end;i++) {
					if(i == page) {
						pager.push("<span>");
						pager.push(i);
						pager.push("</span>");
					}
					else {
						appendItem(pager, i , "[" + i + "]");
					}
				}
				if(page < max) {
					appendItem(pager, page + 1,"下一页");
				}
				$("sycode_topic_comment").lastChild.style.display = "block";
				$id("syblog_album_comment_pager").innerHTML = pager.join('');
			}
			else {
				$("sycode_topic_comment").lastChild.style.display = "none";
			}
		}
	}
}