/*
 * FCKeditor - The text editor for Internet - http://www.fckeditor.net
 * Copyright (C) 2003-2007 Frederico Caldeira Knabben
 *
 * == BEGIN LICENSE ==
 *
 * Licensed under the terms of any of the following licenses at your
 * choice:
 *
 *  - GNU General Public License Version 2 or later (the "GPL")
 *    http://www.gnu.org/licenses/gpl.html
 *
 *  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 *    http://www.gnu.org/licenses/lgpl.html
 *
 *  - Mozilla Public License Version 1.1 or later (the "MPL")
 *    http://www.mozilla.org/MPL/MPL-1.1.html
 *
 * == END LICENSE ==
 *
 * This is the integration file for JavaScript.
 *
 * It defines the FCKeditor class that can be used to create editor
 * instances in a HTML page in the client side. For server side
 * operations, use the specific integration system.
 */

// FCKeditor Class

var FCKeditor = function( instanceName, width, height, toolbarSet, value )
{
	// Properties
	this.InstanceName	= instanceName ;
	this.Width		= width			|| '100%' ;
	this.Height		= height		|| '200' ;
	this.ToolbarSet		= toolbarSet		|| 'Default' ;
	this.Value		= value			|| '' ;
	this.BasePath		= 'js/' ;
	this.CheckBrowser	= true ;
	this.DisplayErrors	= false ;
	this.EnableSafari	= true ;		// This is a temporary property, while Safari support is under development.
	this.EnableOpera	= true ;		// This is a temporary property, while Opera support is under development.

	this.Config			= new Object() ;

	// Events
	this.OnError		= null ;	// function( source, errorNumber, errorDescription )
}

FCKeditor.prototype = {
	Version: '2.4.3',
	VersionBuild: '15657',
	Create: function() {
		document.write( this.CreateHtml() ) ;
	},
	CreateHtml: function() {
		// Check for errors
		if ( !this.InstanceName || this.InstanceName.length == 0 )
		{
			this._ThrowError( 701, 'You must specify an instance name.' ) ;
			return '' ;
		}
	
		var sHtml = '<div>' ;
	
		if ( !this.CheckBrowser || this._IsCompatibleBrowser() )
		{
			sHtml += '<input type="hidden" id="' + this.InstanceName + '" name="' + this.InstanceName + '" value="' + this._HTMLEncode( this.Value ) + '" style="display:none" />' ;
			sHtml += this._GetConfigHtml() ;
			sHtml += this._GetIFrameHtml() ;
		}
		else
		{
			var sWidth  = this.Width.toString().indexOf('%')  > 0 ? this.Width  : this.Width  + 'px' ;
			var sHeight = this.Height.toString().indexOf('%') > 0 ? this.Height : this.Height + 'px' ;
			sHtml += '<textarea name="' + this.InstanceName + '" rows="4" cols="40" style="width:' + sWidth + ';height:' + sHeight + '">' + this._HTMLEncode( this.Value ) + '<\/textarea>' ;
		}
	
		sHtml += '</div>' ;
	
		return sHtml ;
	},
	ReplaceTextarea: function() {
		if ( !this.CheckBrowser || this._IsCompatibleBrowser() )
		{
			// We must check the elements firstly using the Id and then the name.
			var oTextarea = document.getElementById( this.InstanceName ) ;
			var colElementsByName = document.getElementsByName( this.InstanceName ) ;
			var i = 0;
			while ( oTextarea || i == 0 )
			{
				if ( oTextarea && oTextarea.tagName.toLowerCase() == 'textarea' )
					break ;
				oTextarea = colElementsByName[i++] ;
			}
	
			if ( !oTextarea )
			{
				alert( 'Error: The TEXTAREA with id or name set to "' + this.InstanceName + '" was not found' ) ;
				return ;
			}
			oTextarea.editor = this;
			oTextarea.style.display = 'none' ;
			this._InsertHtmlBefore( this._GetConfigHtml(), oTextarea ) ;
			this._InsertHtmlBefore( this._GetIFrameHtml(), oTextarea ) ;
		}
	},
	_InsertHtmlBefore: function( html, element ) {
		if ( element.insertAdjacentHTML )	// IE
			element.insertAdjacentHTML( 'beforeBegin', html ) ;
		else								// Gecko
		{
			var oRange = document.createRange() ;
			oRange.setStartBefore( element ) ;
			var oFragment = oRange.createContextualFragment( html );
			element.parentNode.insertBefore( oFragment, element ) ;
		}
	},
	_GetConfigHtml: function() {
		var sConfig = '' ;
		for ( var o in this.Config )
		{
			if ( sConfig.length > 0 ) sConfig += '&amp;' ;
			sConfig += encodeURIComponent( o ) + '=' + encodeURIComponent( this.Config[o] ) ;
		}
	
		return '<input type="hidden" id="' + this.InstanceName + '___Config" value="' + sConfig + '" style="display:none" />' ;
	},
	_GetIFrameHtml: function() {
		var sFile = 'fckeditor.html' ;
	
		try
		{
			if ( (/fcksource=true/i).test( window.top.location.search ) )
				sFile = 'fckeditor.original.html' ;
		}
		catch (e) { /* Ignore it. Much probably we are inside a FRAME where the "top" is in another domain (security error). */ }
	
		var sLink = this.BasePath + 'editor/' + sFile + '?InstanceName=' + encodeURIComponent( this.InstanceName ) ;
		if (this.ToolbarSet) sLink += '&amp;Toolbar=' + this.ToolbarSet ;
	
		return '<iframe id="' + this.InstanceName + '___Frame" src="' + sLink + '" width="' + this.Width + '" height="' + this.Height + '" frameborder="0" scrolling="no"></iframe>' ;
	},
	_IsCompatibleBrowser: function() {
		return FCKeditor_IsCompatibleBrowser( this.EnableSafari, this.EnableOpera ) ;
	},
	_ThrowError: function( errorNumber, errorDescription ) {
		this.ErrorNumber		= errorNumber ;
		this.ErrorDescription	= errorDescription ;
	
		if ( this.DisplayErrors )
		{
			document.write( '<div style="COLOR: #ff0000">' ) ;
			document.write( '[ FCKeditor Error ' + this.ErrorNumber + ': ' + this.ErrorDescription + ' ]' ) ;
			document.write( '</div>' ) ;
		}
	
		if ( typeof( this.OnError ) == 'function' )
			this.OnError( this, errorNumber, errorDescription ) ;
	},
	_HTMLEncode: function( text ) {
		if ( typeof( text ) != "string" )
			text = text.toString() ;
	
		text = text.replace(
			/&/g, "&amp;").replace(
			/"/g, "&quot;").replace(
			/</g, "&lt;").replace(
			/>/g, "&gt;") ;
	
		return text ;
	},
	GetInstance: function() {
		return FCKeditorAPI.GetInstance(this.InstanceName);
	},
	GetState: function() {
		return this.GetInstance().EditMode;
	},
	SwitchEditMode: function(noUndo) {
		this.GetInstance().SwitchEditMode(noUndo);
	},
	InsertHtml:function (html) {
		var instance = this.GetInstance() ;
		if ( instance.EditMode == FCK_EDITMODE_WYSIWYG )
		{
			return instance.InsertHtml( html ) ;
		}
		else
			alert( 'You must be on WYSIWYG mode!' ) ;
	},
	SetHTML:function (html, resetIsDirty) {
		return this.GetInstance().SetHTML( html, resetIsDirty ) ;
	},
	GetXHTML: function(formatOutput) {
		return this.GetInstance().GetXHTML( formatOutput );
	},
	ExecuteCommand: function( commandName )
	{
		return this.GetInstance().Commands.GetCommand( commandName ).Execute() ;
	},
	GetLength: function() {
		var oDOM = this.GetInstance().EditorDocument ;
	
		var iLength ;
		if ( document.all )
		{
			iLength = oDOM.body.innerText.length ;
		}
		else
		{
			var r = oDOM.createRange() ;
			r.selectNodeContents( oDOM.body ) ;
			iLength = r.toString().length ;
		}
	
		return iLength;
	},
	GetInnerHTML: function() {
		return this.GetInstance().EditorDocument.body.innerHTML ;
	},
	IsDirty: function() {
		return this.GetInstance().IsDirty() ;
	},
	ResetIsDirty: function()
	{
		return this.GetInstance().ResetIsDirty() ;
	},
	Update: function() {
		return this.GetInstance().UpdateLinkedField() ;
	}
}
function FCKeditor_IsCompatibleBrowser( enableSafari, enableOpera )
{
	var sAgent = navigator.userAgent.toLowerCase() ;

	// Internet Explorer
	if ( sAgent.indexOf("msie") != -1 && sAgent.indexOf("mac") == -1 && sAgent.indexOf("opera") == -1 )
	{
		var sBrowserVersion = navigator.appVersion.match(/MSIE (.\..)/)[1] ;
		return ( sBrowserVersion >= 5.5 ) ;
	}

	// Gecko (Opera 9 tries to behave like Gecko at this point).
	if ( navigator.product == "Gecko" && navigator.productSub >= 20030210 && !( typeof(opera) == 'object' && opera.postError ) )
		return true ;

	// Opera
	if ( enableOpera && sAgent.indexOf( 'opera' ) == 0 && parseInt( navigator.appVersion, 10 ) >= 9 )
			return true ;

	// Safari
	if ( enableSafari && sAgent.indexOf( 'safari' ) != -1 )
		return ( sAgent.match( /safari\/(\d+)/ )[1] >= 312 ) ;	// Build must be at least 312 (1.3)

	return false ;
}