var modules = [];
modules.push(FocusViwer = {
	items:[],
	current:-1,
	picture:null,
	bar:null,
	linker:null,
	paused:false,
	running:false,
	initialize: function() {
		if(this.items.length > 0) {
			this.running = true;
			(this.picture = $id("syblog_focus_pic")).firstChild.style.filter="revealtrans(duration=0.5,transition=25)";
			(this.bar = $id("syblog_focus_bar")).innerHTML = "";
			this.linker = $id("syblog_focus_link");
			for(var i = 0;i != this.items.length;i++) {
				this.addButton(i);
			}
			this.picture.parentNode.onmouseover = function() {
				this.paused = true;
			}.bind(this);
			this.picture.parentNode.onmouseout = function() {
				this.paused = false;
			}.bind(this);
			
			this.switchFocus();
			setInterval(this.switchFocus.bind(this),5000);
		}
	},
	addButton: function(idx) {
		var button = document.createElement("div");
		button.focusid = idx;
		button.viwer = this;
		button.onmouseover = function() {
			this.viwer.showFocus(this.focusid);
		};
		button.innerHTML = idx + 1;
		this.bar.appendChild(button);
	},
	addItem: function(item) {
		if(this.running) {
			this.addButton(this.items.length);
		}
		this.items.push(item);
	},
	switchFocus: function() {
		if(!this.paused) {
			this.showFocus((this.current + 1) % this.items.length);
		}
	},
	showFocus: function(idx) {
		this.bar.childNodes[Math.max(this.current,0)].className = "";
		this.bar.childNodes[this.current = idx].className = "current";
		this.linker.innerText = this.items[idx].title;
		this.linker.href = this.items[idx].link;
		with(this.picture) {
			if(window.isIE) {
				with(firstChild.filters[0]) {
					apply();
					transition = 25;
					play();
				}
			}
			href = this.items[idx].link;
			firstChild.src = this.items[idx].image;
		}
	}
});
window.onload = function() {
	for(var i = 0;i != modules.length;i++) {
		modules[i].initialize();
	}
	checklogin();
}
function userlogin(f) {
	$(f).post(function(r){
		setLoginInfo();
	});
}
function checklogin(callback){
	if(Cookie.get("me")) {
		setLoginInfo();
	}
}
function setLoginInfo(n) {
	$id("syblog_login_user").innerHTML = Cookie.get("name");
	$id("syblog_manage_button").href = "/" + Cookie.get("me") + "#/ui/common/manager.htm";
	$id("syblog_login_show").style.display = "block";
	$id("syblog_login_form").parentNode.style.display = "none";
}
function logout() {
	Cookie.remove("user|me|name");
	$id("syblog_login_show").style.display = "none";
	$id("syblog_login_form").parentNode.style.display = "block";
}