﻿var FileUploader = function(node, uploadPath, width, fullMode, limit) {
	this.container = node;
	this.uploadPath = uploadPath;
	this.width = width || 670;
	this.fullMode = !!fullMode;
	this.description = "";
	this.uploadPage = "/upload.htm?l=" + (limit || 1);
}
FileUploader.prototype = {
	initialize: function() {
		this.uploadId = String.generateGuid();
		with(this.container.style) {
			fontFamily = "宋体";
			fontSize = "12px";
			width = this.width + "px";
			height = "46px";
			border = "1px solid #ccc";
			textAlign = "left";
		}
		var detCss = "float:left;width:" + Math.round((this.width - 60 - (this.fullMode ? 160 : 110))/(this.fullMode ? 5 : 3) - 4) + "px;height:14px;padding:2px;color:blue;text-align:right";
		
		this.upLoadContainer = document.createElement("div");
		this.container.appendChild(this.upLoadContainer);

		var upIFrameContainer = document.createElement("div");
		with(upIFrameContainer) {
			style.cssText = "float:left;width:" + (this.width - 60) + "px";
			innerHTML = '<iframe src="' + this.uploadPage + '" allowtransparency="true" frameborder="0" height="46px" scrolling="no" width="100%" ></iframe>';
		}
		this.upLoadContainer.appendChild(upIFrameContainer);
		this.upIFrame = upIFrameContainer.firstChild;
		
		var upBtnContainer = document.createElement("div");
		upBtnContainer.style.cssText = "height:46px;width:57px;float:left;border-left:1px solid #ccc;text-align:center";
		this.upLoadContainer.appendChild(upBtnContainer);
		
		with(this.upButton =  document.createElement("button")) {
			style.marginTop = "10px";
			innerHTML = "上传";
		}
		upBtnContainer.innerHTML = '<a href="#" style="text-decoration:none" onclick="return false"></a>';
		upBtnContainer.firstChild.appendChild(this.upButton);
		this.upButton.onclick = this.startUpLoad.bind(this);
		
		this.upInfoContainer = document.createElement("div");
		this.upInfoContainer.style.cssText = "width:100%";
		this.upInfoContainer.style.display = "none";
		this.container.appendChild(this.upInfoContainer);
		
		var upDetailContainer = document.createElement("div");
		
		with(upDetailContainer) {
			style.cssText = "float:left;width:" + (this.width - 60) + "px";
			innerHTML = '<div style="width:' + (this.width - 60) + 'px;height:18px;border-bottom:1px solid #ccc;position:relative;overflow:hidden"></div>';
		}
		
		var upDetail = upDetailContainer.firstChild;
		
		var item = document.createElement("div");
		item.style.cssText = "float:left;width:24px;height:12px;padding:2px 0px";
		item.innerHTML = "大小";
		upDetail.appendChild(item);
		
		with(this.totalBytes = document.createElement("div")) {
			style.cssText = detCss;
			innerHTML = "-";
		}
		upDetail.appendChild(this.totalBytes);
		
		item = document.createElement("div");
		item.style.cssText = "float:left;width:36px;height:12px;padding:2px 0px";
		item.innerHTML = "已上传";
		upDetail.appendChild(item);
		
		with(this.transferredBytes = document.createElement("div")) {
			style.cssText = detCss;
			innerHTML = "-";
		}
		upDetail.appendChild(this.transferredBytes);
		
		item = document.createElement("div");
		item.style.cssText = "float:left;width:48px;height:12px;padding:2px 0px";
		item.innerHTML = "平均速度";
		upDetail.appendChild(item);
		
		with(this.speed = document.createElement("div")) {
			style.cssText = detCss;
			innerHTML = "-";
		}
		upDetail.appendChild(this.speed);
		
		if(this.fullMode) {
			item = document.createElement("div");
			item.style.cssText = "float:left;width:24px;height:12px;padding:2px 0px";
			item.innerHTML = "用时";
			upDetail.appendChild(item);
			
			with(this.transferredTime = document.createElement("div")) {
				style.cssText = detCss;
				innerHTML = "-";
			}
			upDetail.appendChild(this.transferredTime);
			
			item = document.createElement("div");
			item.style.cssText = "float:left;width:24px;height:12px;padding:2px 0px";
			item.innerHTML = "剩余";
			upDetail.appendChild(item);
			
			with(this.remainTime = document.createElement("div")) {
				style.cssText = detCss;
				innerHTML = "-";
			}
			upDetail.appendChild(this.remainTime);
		} else {
			this.transferredTime = this.remainTime = new Object();
		}
		
		var barWidth = this.width - 74;
		var upParentBarContainer = document.createElement("div");
		upParentBarContainer.style.cssText = "margin:4px 5px;width:" + barWidth +"px;border:1px solid #ccc; background:#fff; position: relative;height:16px";
		
		with(this.parentText = document.createElement("div")) {
			style.cssText = "font-size: 14px;z-index: 99; width: " + barWidth +"px; text-align:center; position: absolute; height: 16px";
			innerHTML = '0%';
		}
		upParentBarContainer.appendChild(this.parentText);
		
		with(this.parentBar = document.createElement("div")) {
			style.cssText = "width:0%;background-color:#9cf;overflow:hidden;height:16px";
			innerHTML = '&nbsp;';
		}
		upParentBarContainer.appendChild(this.parentBar);
		
		this.upInfoContainer.appendChild(upDetailContainer);
		
		
		upDetailContainer.appendChild(upParentBarContainer);
		
		var cancelBtnContainer = document.createElement("div");
		cancelBtnContainer.style.cssText = "height:46px;width:57px;float:left; border-left:1px solid #ccc; text-align:center";
		this.upInfoContainer.appendChild(cancelBtnContainer);
		with(this.cancelButton =  document.createElement("button")) {
			style.marginTop = "10px";
			innerHTML = "取消";
		}
		this.cancelButton.onclick = this.cancelUpLoad.bind(this);
		cancelBtnContainer.innerHTML = '<a href="#" style="text-decoration:none" onclick="return false"></a>';
		cancelBtnContainer.firstChild.appendChild(this.cancelButton);
	},
	onUploadBefore: function(ifrom) {
		if(ifrom.elements[0].value.length > 0) {
			return true;
		}
		else {
			alert("没有打开的文件");
			return false;
		}
	},
	onUploadCompleted: function(name,size,date) {
	},
	startUpLoad: function(){
		var iform = this.upIFrame.contentWindow.document.forms[0];
		if(this.onUploadBefore(iform)) {
			this.totalBytes.innerHTML = "-";
			this.transferredBytes.innerHTML = "-";
			this.speed.innerHTML = "-";
			this.transferredTime.innerHTML = "-";
			this.remainTime.innerHTML = "-";
			this.parentBar.style.width = this.parentText.innerHTML = "0%";
			iform.action = iform.action + "uploadId=" + this.uploadId + "&uploadPath=" + this.uploadPath;
			iform.submit();
			this.lastTime = new Date().getTime();
			this.isConnection = true;
			this.progressUpdate();
			
			this.upInfoContainer.style.display = "block";
			this.upLoadContainer.style.display = "none";
			return event.returnValue = !(event.cancelBubble = true);
		}
	},
	cancelUpLoad: function(){
		if(this.isConnection)
		{
			this.isConnection = false;
			this.upIFrame.src = this.uploadPage;
			this.upLoadContainer.style.display = "block";
			this.upInfoContainer.style.display = "none";
		}
	},
	progressUpdate: function() {
		if(this.isConnection){
			var httpRequest = new HTTPRequest(true,true);
			httpRequest.send("/UploadProgress.aspx","uploadId=" + this.uploadId,this.progressShow.bind(this));
		}
	},
	progressShow: function(r) {
		var r = r.getXML()
		if(r == null){
			window.setTimeout(this.progressUpdate.bind(this), 1000);
			return;
		}
		r = r.documentElement;
		switch(r.getAttribute("st")) {
			case "ERROR":
				this.cancelUpLoad();
				alert(r.getAttribute("er"));
				break;
			case "Complete":
				this.cancelUpLoad();
				for(var i = 0;i < r.childNodes.length;i++) {
				    with(r.childNodes[i]) {
				        this.onUploadCompleted(encodeURI(getAttribute("name")), getAttribute("size"), getAttribute("date"));
				    }
				}
				break;
			case "ReceivingData":
				var fileSize = r.getAttribute("fs");
				var uploadSize = r.getAttribute("up");
				var perentStat = Math.round(uploadSize/fileSize * 100 + 0.49);
				perentStat += "%";
				var t = new Date().getTime() - this.lastTime;
				var sendSpeed = Math.round(uploadSize / t + 0.49);
				
				this.totalBytes.innerHTML = Math.round(fileSize / 1024 + 0.49) + " KB";
				this.transferredBytes.innerHTML = Math.round(uploadSize / 1024 + 0.49) + " KB";
				this.speed.innerHTML = sendSpeed + " KB/S";
				this.transferredTime.innerHTML = Math.round(t / 1000 + 0.49) + "秒";
				this.remainTime.innerHTML = Math.round((fileSize - uploadSize) / sendSpeed / 1000 + 0.49) + "秒";
				this.parentText.innerHTML = perentStat;
				this.parentBar.style.width = perentStat;
			default:
				window.setTimeout(this.progressUpdate.bind(this), 1000);
				break;
		}
	}
}