<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
	<xsl:template match="/html/body">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
			  	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
			  	<script language="javascript">
			  		if(typeof(parent.showResult)!="function") {
			  			location.replace(location.href.substring(0,location.href.lastIndexOf("/")) + "/#album.xml");
			  		}
			  		window.onload = function() {
						var outnode = document.getElementById("output");
						var html = outnode.innerHTML;
						outnode.innerHTML = " ";
						var replacement = 'src="' + location.href.substr(0,location.href.lastIndexOf('/')) + "/album/thumb/";
						html=html.replace(/_src="album\/thumb\//gi,replacement);
						parent.window.showResult(html,location.href);
			  		}
			  	</script>
			</head>
			<body><div id="output">
				<div class="syblog_album">
					<div class="syblog_album_right_bar">
						<div class="syblog_album_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
						<div class="syblog_album_content">
							<div id="syblog_album_list">
								<xsl:apply-templates select="a" />
								<xsl:if test="count(a/img)=0">
									<p align="center">相册中没有相片</p>
								</xsl:if>
							</div>
							<div id="syblog_album_viewer">
								<div id="syblog_album_title">&#160;</div>
								<div class="syblog_album_photo">
									<div id="syblog_album_photo"><img border="0" alt="photo" /></div>
									<div id="syblog_album_photo_title">描述</div>
								</div>
								<div class="syblog_album_film">
									<div class="syblog_album_film_arrow">
										<a class="syblog_album_film_barrow">&#160;</a>
									</div>
									<div id="syblog_album_film_content">&#160;</div>
									<div class="syblog_album_film_arrow">
										<a class="syblog_album_film_farrow">&#160;</a>
									</div>
								</div>
								<div class="sycode_topic_control">
									<div class="sycode_topic_toptip">
										<div>&#160;</div>
										<div>评论(<span id="sycode_album_comment">?</span>)</div>
										<div>浏览(<span id="sycode_album_view">?</span>)</div>
										<div id="sycode_album_createtime">?</div>
										<div class="static">
											<a href="#" onclick="$id('syblog_album_viewer').style.display='none';$id('syblog_album_list').style.display='block';$id('syblog_body').scrollTop=0;return false;">返回</a>
										</div>
									</div>
								</div>
								<div id="sycode_topic_comment">
									<p class="sycode_topic_comment_title">评论:</p>
									<div>&#160;</div>
									<div class="syblog_pager">
										<div class="syblog_pager_right_bar">
											<div class="syblog_pager_header_bar"><span class="left"></span><span class="right"></span></div>
											<div class="syblog_pager_content">
												<div id="syblog_album_comment_pager">&#160;</div>
											</div>
											<div class="syblog_pager_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
										</div>
									</div>
								</div>
								<div class="sycode_topic_comment_form">
									<div class="sycode_topic_comment_form_right_bar">
										<div class="sycode_topic_comment_form_header_bar"><span class="left"></span><span class="right"></span></div>
										<div class="sycode_topic_comment_form_content">
											<form id="sycode_topic_comment_form" onsubmit="return false" action="/PostAlbumComment.aspx">
												<input type="hidden" name="id" value="0"></input>
												<div>
													<span>署　名：</span>
													<input maxlength="16" type="text" class="sign" name="sign"/>
												</div>
												<div>
													<span>主　页：</span>
													<input maxlength="255" size="40" type="text" class="sign" name="site" value="http://"/>
												</div>
												<div>
													<span>验证码：</span>
													<input maxlength="5" min="5" max="5" onclick="if(!this.nextSibling.src)this.nextSibling.src='CRCImage.aspx?mod=comment&amp;' + (new Date()).getTime()" msg="必须输入验证码" type="text" class="crcode" name="crcode" style="ime-mode:disabled"/><img class="crcimg" alt="点击验证码输入框显示验证码" onclick="this.src='/CRCImage.aspx?mod=comment&amp;' + (new Date()).getTime()" />
												</div>
												<div>
													<span>评论内容：</span>
													<textarea name="content" min="1" msg="必须输入评论内容" onfocus="if(this.value=='请输入评论内容')this.value=''">请输入评论内容</textarea>
												</div>
												<div>
													<button name="submit" onclick="postComment(this)">发表评论</button>
												</div>
											</form>
										</div>
										<div class="sycode_topic_comment_form_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
									</div>
								</div>
							</div>
						</div>
						<div class="syblog_album_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
					</div>
				</div>
			</div></body>
		</html>
	</xsl:template>
	<xsl:template match="a">
		<xsl:if test="count(img)>0">
			<div class="syblog_album_box" title="{@name}" alt="{@id}">
				<xsl:attribute name="onclick">showAlbum(this.getAttribute('alt'),this.getAttribute('title'),[<xsl:for-each select="img"><xsl:if test="position()>1">,</xsl:if>{description:'<xsl:call-template name="captureQuot"><xsl:with-param name="processText" select="@alt"/></xsl:call-template>',src:'<xsl:call-template name="captureQuot"><xsl:with-param name="processText" select="@src"/></xsl:call-template>'}</xsl:for-each>])</xsl:attribute>
				<div class="syblog_album_title">
					<xsl:value-of select="@name" />
				</div>
				<div class="syblog_album_img">
					<img border="0" _src="album/thumb/{img[number(../@cover)+1]/@src}" />
				</div>
				<div class="syblog_album_count">
					<xsl:value-of select="count(img)" />P
				</div>
			</div>
		</xsl:if>
	</xsl:template>
	<xsl:template name="captureQuot">
		<xsl:param name="processText"/>
		<xsl:call-template name="captureSingleQuot">
			<xsl:with-param name="processText">
				<xsl:call-template name="captureDoubleQuot">
					<xsl:with-param name="processText" select="$processText" />
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template name="captureSingleQuot">
		<xsl:param name="processText"/>
		<xsl:choose>
			<xsl:when test="contains($processText, &quot;'&quot;)">
				<xsl:value-of select="substring-before($processText,&quot;'&quot;)" />
				<xsl:text>\'</xsl:text>
				<xsl:call-template name="captureSingleQuot">
					<xsl:with-param name="processText" select="substring-after($processText,&quot;'&quot;)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$processText"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="captureDoubleQuot">
		<xsl:param name="processText"/>
		<xsl:choose>
			<xsl:when test="contains($processText, '&quot;')">
				<xsl:value-of select="substring-before($processText,'&quot;')" />
				<xsl:text>\&amp;quot;</xsl:text>
				<xsl:call-template name="captureDoubleQuot">
					<xsl:with-param name="processText" select="substring-after($processText,'&quot;')"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$processText"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>