<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	  	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	  	<title><xsl:value-of select="head/title" /></title>
	  	<script language="javascript">
	  		if(typeof(parent.showResult)!="function") {
	  			location.replace("../#" + location.pathname);
	  		}
	  		window.onload = function() {
				parent.showResult(document.getElementById("output").innerHTML,location.href);
	  		}
	  	</script>
	</head>
	<body>
		<div id="output">
			<xsl:choose>
				<xsl:when test="count(body/p)=0">
					<p class="syblog_empty" align="center"><xsl:value-of select="head/title" />里没有内容</p>
				</xsl:when>
				<xsl:otherwise>
					<div class="syblog_collection">
						<div class="syblog_collection_right_bar">
							<div class="syblog_collection_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
							<div class="syblog_collection_content">
								<div class="syblog_collection_list"><xsl:value-of select="head/title" /></div>
								<ol class="syblog_collection_list">
									<xsl:apply-templates select="body/p" />
								</ol>
							
</div>
							<div class="syblog_collection_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
						</div>
					</div>
				</xsl:otherwise>
			</xsl:choose>
		</div>
	</body>
</html>
</xsl:template>
<xsl:template match="body/p">
	<li>
		<a target="_blank" href="{a/@href}"><xsl:value-of select="a" /></a>
		<div>
			<xsl:value-of select="p" />
		</div>
	</li>
</xsl:template>
</xsl:stylesheet>