<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/html">
	<xsl:apply-templates select="/html/body/a" />
</xsl:template>

<xsl:template match="/html/body/a">
	<div class="syblog_topic_comment">
		<div class="syblog_topic_comment_right_bar">
			<div class="syblog_topic_comment_header_bar"><span class="left"></span><span class="right"></span></div>
			<div class="syblog_topic_comment_content">
				<div class="syblog_topic_comment_bloger">
					<xsl:choose>
						<xsl:when test="string-length(@href)>0">
							<a target="_blank" href="{@href}"><xsl:value-of select="@name" /></a>
						</xsl:when>
						<xsl:otherwise><xsl:value-of select="@name" /></xsl:otherwise>
					</xsl:choose>
				</div>
				<div class="syblog_topic_comment_body">
					<div>
						<xsl:value-of select="@time" />
					</div>
					<pre>
						<xsl:choose>
							<xsl:when test="string-length(@deleted)>0">
								<span>该评论已被博主删除</span>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="captureUBB">
									<xsl:with-param name="processText">
										<xsl:value-of select="."/>
									</xsl:with-param>
								</xsl:call-template>
							</xsl:otherwise>
						</xsl:choose>
					</pre>
				</div>
			</div>
			<div class="syblog_topic_comment_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	</div>
</xsl:template>

<xsl:template name="captureUBB">
	<xsl:param name="processText"/>
	<xsl:variable name="remainingContent" select="$processText"/>
	<xsl:variable name="remaining_after_end_ubb" select="substring-after($processText, '[/')"/>
	<xsl:variable name="remainingContent_after_ubb" select="substring-after($remaining_after_end_ubb, ']')"/>

	<xsl:choose>
		<xsl:when test="contains($processText, '[') and contains($processText, ']')">
			<xsl:choose>
				<xsl:when test="starts-with($processText, '[')">
					<xsl:call-template name="processUBB">
						<xsl:with-param name="ubbType" select="translate(substring-after(substring-before($processText, ']'), '['),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
						<xsl:with-param name="content" select="substring-after(substring-before($processText, '[/'), ']')"/>
						<xsl:with-param name="backingContent" select="substring-after($processText, ']')"/>
						<xsl:with-param name="remainingContent" select="$remainingContent_after_ubb"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="substring-before($processText, '[')"/>
					<xsl:call-template name="captureUBB">
						<xsl:with-param name="processText" select="concat('[',substring-after($processText, '['))"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$remainingContent"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="processUBB">
	<xsl:param name="ubbType"/>
	<xsl:param name="content"/>
	<xsl:param name="backingContent"/>
	<xsl:param name="remainingContent"/>
	
	<xsl:choose>
		<xsl:when test="starts-with(translate(substring-before(substring-after($backingContent, '['),']'),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz'), concat('/',$ubbType))">
			<xsl:choose>
				<xsl:when test="$ubbType = 'b'">
					<xsl:call-template name="b">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'email'">
					<xsl:call-template name="email">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'fly'">
					<xsl:call-template name="fly">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'i'">
					<xsl:call-template name="i">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'img'">
					<xsl:call-template name="img">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'move'">
					<xsl:call-template name="move">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'quote'">
					<xsl:call-template name="quote">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'u'">
					<xsl:call-template name="u">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:when test="$ubbType = 'url'">
					<xsl:call-template name="url">
						<xsl:with-param name="content" select="$content"/>
						<xsl:with-param name="remainingContent" select="$remainingContent"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>[</xsl:text><xsl:value-of select="$ubbType"/><xsl:text>]</xsl:text>
					<xsl:call-template name="captureUBB">
						<xsl:with-param name="processText" select="$backingContent"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:when test="contains($ubbType, '=') and starts-with(translate(substring-before(substring-after($backingContent, '['),']'),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz'), concat('/',substring-before($ubbType, '=')))">
			<xsl:call-template name="processUBB2">
				<xsl:with-param name="ubbType" select="substring-before($ubbType, '=')"/>
				<xsl:with-param name="ubbParam" select="substring-after($ubbType, '=')"/>
				<xsl:with-param name="content" select="$content"/>
				<xsl:with-param name="backingContent" select="$backingContent"/>
				<xsl:with-param name="remainingContent" select="$remainingContent"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>[</xsl:text><xsl:value-of select="$ubbType"/><xsl:text>]</xsl:text>
			<xsl:call-template name="captureUBB">
				<xsl:with-param name="processText" select="$backingContent"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="processUBB2">
	<xsl:param name="ubbType"/>
	<xsl:param name="ubbParam"/>
	<xsl:param name="content"/>
	<xsl:param name="backingContent"/>
	<xsl:param name="remainingContent"/>
	
	<xsl:choose>
		<xsl:when test="$ubbType = 'align'">
			<xsl:call-template name="align">
				<xsl:with-param name="param" select="$ubbParam"/>
				<xsl:with-param name="content" select="$content"/>
				<xsl:with-param name="remainingContent" select="$remainingContent"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$ubbType = 'color'">
			<xsl:call-template name="color">
				<xsl:with-param name="param" select="$ubbParam"/>
				<xsl:with-param name="content" select="$content"/>
				<xsl:with-param name="remainingContent" select="$remainingContent"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$ubbType = 'email'">
			<xsl:call-template name="email2">
				<xsl:with-param name="param" select="$ubbParam"/>
				<xsl:with-param name="content" select="$content"/>
				<xsl:with-param name="remainingContent" select="$remainingContent"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$ubbType = 'face'">
			<xsl:call-template name="face">
				<xsl:with-param name="param" select="$ubbParam"/>
				<xsl:with-param name="content" select="$content"/>
				<xsl:with-param name="remainingContent" select="$remainingContent"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$ubbType = 'size'">
			<xsl:call-template name="size">
				<xsl:with-param name="param" select="$ubbParam"/>
				<xsl:with-param name="content" select="$content"/>
				<xsl:with-param name="remainingContent" select="$remainingContent"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="$ubbType = 'url'">
			<xsl:call-template name="url2">
				<xsl:with-param name="param" select="$ubbParam"/>
				<xsl:with-param name="content" select="$content"/>
				<xsl:with-param name="remainingContent" select="$remainingContent"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>[</xsl:text><xsl:value-of select="$ubbType"/><xsl:text>=</xsl:text><xsl:value-of select="$ubbParam"/><xsl:text>]</xsl:text>
			<xsl:call-template name="captureUBB">
				<xsl:with-param name="processText" select="$backingContent"/>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="b">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<b><xsl:value-of select="$content"/></b>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="email">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<a href="mailto:{$content}"><xsl:value-of select="$content"/></a>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="fly">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<marquee behavior="alternate"><xsl:value-of select="$content"/></marquee>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="i">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<i><xsl:value-of select="$content"/></i>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="img">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<img _src="{$content}"/>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="move">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<marquee><xsl:value-of select="$content"/></marquee>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="quote">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<blockquote><i><xsl:value-of select="$content"/></i></blockquote>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="u">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<u><xsl:value-of select="$content"/></u>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="url">
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<a href="{$content}" target="_blank"><xsl:value-of select="$content"/></a>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="align">
	<xsl:param name="param"/>
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<p align="{$param}"><xsl:value-of select="$content"/></p>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="color">
	<xsl:param name="param"/>
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<font color="{$param}"><xsl:value-of select="$content"/></font>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="email2">
	<xsl:param name="param"/>
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<a href="mailto:{$param}"><xsl:value-of select="$content"/></a>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="face">
	<xsl:param name="param"/>
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<font face="{$param}"><xsl:value-of select="$content"/></font>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="size">
	<xsl:param name="param"/>
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<font size="{$param}"><xsl:value-of select="$content"/></font>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>

<xsl:template name="url2">
	<xsl:param name="param"/>
	<xsl:param name="content"/>
	<xsl:param name="remainingContent"/>
	<a href="{$param}" target="_blank"><xsl:value-of select="$content"/></a>
	<xsl:call-template name="captureUBB">
		<xsl:with-param name="processText" select="$remainingContent"/>
	</xsl:call-template>
</xsl:template>
</xsl:stylesheet>