<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="userdir">/<xsl:value-of select="dataset/@u"/>/</xsl:variable>
<xsl:variable name="url"><xsl:value-of select="$userdir"/>friend/</xsl:variable>
<xsl:variable name="page"><xsl:choose><xsl:when test="number(dataset/@p)>0"><xsl:value-of select="dataset/@p"/></xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose></xsl:variable>
<xsl:variable name="size"><xsl:value-of select="dataset/@s"/></xsl:variable>
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/dataset ">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	  	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	  	<script language="javascript">
	  		if(typeof(parent.showResult)!="function") {
	  			location.replace("<xsl:value-of select="$userdir" />#" + location.pathname);
	  		}
	  		window.onload = function() {
				parent.showResult(document.getElementById("output").innerHTML.replace(/\s_src=/gmi," src="),location.href);
	  		}
	  	</script>
	</head>
	<body>
		<div id="output">
			<xsl:choose>
				<xsl:when test="count(table[1]/row)=0">
					<p class="syblog_empty" align="center">博主还没有添加过任何好友</p>
				</xsl:when>
				<xsl:otherwise>
					<div class="syblog_friend">
						<div class="syblog_friend_right_bar">
							<div class="syblog_friend_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
							<div class="syblog_friend_content">
								<div class="syblog_friend_list">
									<xsl:apply-templates select="table[1]/row" />
								</div>
							</div>
							<div class="syblog_friend_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
						</div>
					</div>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:apply-templates select="table[2]/row" />
		</div>
	</body>
</html>
</xsl:template>
<xsl:template match="table[1]/row">
	<div class="syblog_friend_item">
		<div class="syblog_friend_head">
			<img onclick="showCard(this)" _src="/{account}/head/" alt="{account}" title="{name}" />
		</div>
		<div class="syblog_friend_name">
			<a target="_blank" href="/{account}"><xsl:value-of select="name" /></a>
		</div>
	</div>
</xsl:template>
<xsl:template match="table[2]/row">
	<xsl:if test="number(count)>number($size)">
		<div class="syblog_pager">
			<div class="syblog_pager_right_bar">
				<div class="syblog_pager_header_bar"><span class="left"></span><span class="right"></span></div>
				<div class="syblog_pager_content">
					<xsl:call-template name="pager">
						<xsl:with-param name="p">
							<xsl:value-of select="ceiling(number(count) div number($size))"/>
						</xsl:with-param>
					</xsl:call-template>
				</div>
				<div class="syblog_pager_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
			</div>
		</div>
	</xsl:if>
</xsl:template>
<xsl:template name="pager">
	<xsl:param name="p"/>
	<xsl:if test="$p>1">
		<xsl:if test="($page)>1">
			<a target="iframe_xml_http_request" href="{$url}{number($page)-1}.xml">上一页</a>
		</xsl:if>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:choose>
					<xsl:when test="$p>10 and $page>5">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:value-of select="number($page)-5"/>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="number($p)-10"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:choose>
					<xsl:when test="$p>10">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:choose>
									<xsl:when test="$page>5">
										<xsl:value-of select="number($page)+5"/>
									</xsl:when>
									<xsl:otherwise>10</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:if test="$p>number($page)">
			<a target="iframe_xml_http_request" href="{$url}{number($page)+1}.xml">下一页</a>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="loop">
	<xsl:param name="min"/>
	<xsl:param name="max"/>
	<xsl:if test="$max>=$min">
		<xsl:choose>
			<xsl:when test="number($min)=number($page)">
				<span>
					<xsl:value-of select="$min"/>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<a target="iframe_xml_http_request" href="{$url}{$min}.xml">[<xsl:value-of select="$min" />]</a>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:value-of select="number($min)+1"/>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:value-of select="$max"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>