<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="footer.xsl"/>
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="zh-CN">
			<head>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<title><xsl:value-of select="head/title" /></title>
				<link rel="icon" type="image/x-icon" href="/favicon.ico" />
				<style type="text/css">
					html,body {
						width:100%;
						font-size:12px;
					}
					div.syblog_header_frame {
						text-align:center;
						margin:auto;
						width:740px;
						line-height:30px;
					}
					div.syblog_header_logo {
						float:left;
					}
					div.syblog_header_link {
						float:right;
						text-align:right;
						padding:15px 5px 0 0;
					}
					div.syblog_header_link span {
						margin:0 6px;
					}
					div.syblog_body_frame {
						clear:both;
						margin:auto;
						width:740px;
					}
					div.syblog_copyright_frame {
						clear:both;
						text-align:center;
						margin:20px auto 0;
						width:740px;
						line-height:30px;
						border-top:1px solid #bbb;
					}
				</style>
				<xsl:copy-of select="head/style" />
				<script type="text/javascript" src="/js/lib.js"></script>
				<script type="text/javascript">
					var host = "<xsl:value-of select="document('../../host.xml')//conf/host"/>/";
				</script>
				<xsl:copy-of select="head/script" />
			</head>
		<body>
			<div class="syblog_header_frame">
				<div class="syblog_header_logo"><img src="/ui/img/logo.gif" /></div>
				<div class="syblog_header_link"><a target="_self" href="/register.xml">注册</a><span>|</span><a target="_self" href="/forgetpwd.xml">找回密码</a><span>|</span><a target="_self" href="/help.xml">帮助</a><span>|</span><a target="_self" href="/">返回首页</a></div>
			</div>
			<div class="syblog_body_frame">
				<xsl:value-of disable-output-escaping="yes" select="body" />
				<xsl:if test="system-property('xsl:vendor')='Transformiix'">
					<div style="display:none" id="syblog_transformiix"></div>
					<script language="javascript"> 
						var syblog_transformiix = document.getElementById("syblog_transformiix");
						syblog_transformiix.parentNode.innerHTML = syblog_transformiix.parentNode.firstChild.textContent;
					</script>
				</xsl:if>
			</div>
			<xsl:call-template name="footer" />
		</body>
	</html>
</xsl:template>
</xsl:stylesheet>