<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	  	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	  	<title>doc</title>
	  	<script language="javascript">
	  		if(typeof(parent.showResult)!="function") {
	  			location.replace("./#info.xml");
	  		}
	  		window.onload = function() {
				parent.showResult(document.getElementById("output").innerHTML, location.href);
	  		}
	  	</script>
	</head>
	<body>
		<div id="output">
			<div class="syblog_userinfo">
				<div class="syblog_userinfo_right_bar">
					<div class="syblog_userinfo_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
					<div class="syblog_userinfo_content">
						<xsl:apply-templates select="body"/>
					</div>
					<div class="syblog_userinfo_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
				</div>
			</div>
		</div>
	</body>
</html>
</xsl:template>
<xsl:template match="body">
	<div class="syblog_userinfo_field">基本资料</div>
	<p>
		<div class="syblog_userinfo_fieldname">姓名：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='realname']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">性别：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='gender']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">生日：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='birthday']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">农历：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='birthday2']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">生肖：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='aniproto']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">星座：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='constellation']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">民族：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='people']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">故乡：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='oprovince']/span[2]" />
			<xsl:if test="p[@id='oprovince']/span[2]/@title &gt; 0">
				<xsl:value-of select="p[@id='oprovince']/span[3]" />
			</xsl:if>
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">现居住地：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='province']/span[2]" />
			<xsl:if test="p[@id='province']/span[2]/@title &gt; 0">
				<xsl:value-of select="p[@id='province']/span[3]" />
			</xsl:if>
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">个人说明：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='resume']/span[2]" />
		</div>
	</p>
	
	<div class="syblog_userinfo_field">个人信息</div>
	<p>
		<div class="syblog_userinfo_fieldname">身高：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='height']/span[2]" />
			<xsl:text>厘米</xsl:text>
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">体重：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='weight']/span[2]" />
			<xsl:text>公斤</xsl:text>
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">血型：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='blood']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">婚姻状况：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='marital']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">是否抽烟：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='smoke']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">是否饮酒：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='drink']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">职业：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='industry']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">职位：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='industry']/span[3]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">年薪：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='salary']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">学历：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='knowledge']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">毕业院校：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='school']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">技能专长：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='speciality']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">性格特征：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='character']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">其他性格特征：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='character']/span[3]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">兴趣爱好：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='hobby']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">其他兴趣爱好：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='hobby']/span[3]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">喜欢的运动：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='sport']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">喜欢的书籍：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='book']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">喜欢的音乐：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='music']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">喜欢的电影：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='movie']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">喜欢的明星：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='star']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">个人说明：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='resume']/span[2]" />
		</div>
	</p>
	
	<div class="syblog_userinfo_field">联系方式</div>
	<p>
		<div class="syblog_userinfo_fieldname">联系地址：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='address']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">邮政编码：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='postcode']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">联系电话：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='phone']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">email：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='email']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">MSN：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='msn']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">QQ：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='qq']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">Skype：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='skype']/span[2]" />
		</div>
	</p>
	<p>
		<div class="syblog_userinfo_fieldname">其他联系方式：</div>
		<div class="syblog_userinfo_fieldvalue">
			<xsl:value-of select="p[@id='contact']/span[2]" />
		</div>
	</p>
</xsl:template>
</xsl:stylesheet>