<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="page"><xsl:value-of select="html/body/@p"/></xsl:variable>
<xsl:variable name="size"><xsl:value-of select="html/body/@s"/></xsl:variable>
<xsl:variable name="count"><xsl:value-of select="html/body/@c"/></xsl:variable>
<xsl:variable name="method"><xsl:value-of select="html/@method"/></xsl:variable>
<xsl:template match="/html">
	<xsl:choose>
		<xsl:when test="count(body/p)>0">
			<xsl:for-each select="body/p">
				<p>
					<input type="checkbox" name="leave" value="{@id}" />
					<xsl:choose>
						<xsl:when test="string-length(@href)>0">
							<a target='_blank' href="a/@href"><xsl:value-of select="a" /></a>
							<layer>——<xsl:value-of select="@time" /></layer>
						</xsl:when>
						<xsl:otherwise>
							<a><xsl:value-of select="a" /></a>
							<layer>——<xsl:value-of select="@time" /></layer>
						</xsl:otherwise>
					</xsl:choose>
					<span><xsl:value-of select="p" /></span>
				</p>
			</xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
			<div class="manager_message_null">
				当前没有留言
			</div>
		</xsl:otherwise>
	</xsl:choose>
	<xsl:if test="number($count)>number($size)">
		<div class="syblog_pager">
			<div class="syblog_pager_right_bar">
				<div class="syblog_pager_header_bar"><span class="left"></span><span class="right"></span></div>
					<div class="syblog_pager_content">
						<xsl:call-template name="pager">
							<xsl:with-param name="p">
								<xsl:value-of select="ceiling(number($count) div number($size))"/>
							</xsl:with-param>
						</xsl:call-template>
					</div>
				<div class="syblog_pager_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
			</div>
		</div>
	</xsl:if>
</xsl:template>
<xsl:template name="pager">
	<xsl:param name="p"/>
	<xsl:if test="$p>1">
		<xsl:if test="($page)>1">
			<a href="#" onclick="{$method}({number($page)-1});return false;">上一页</a>
		</xsl:if>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:choose>
					<xsl:when test="$p>10 and $page>5">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:value-of select="number($page)-5"/>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="number($p)-10"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:choose>
					<xsl:when test="$p>10">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:choose>
									<xsl:when test="$page>5">
										<xsl:value-of select="number($page)+5"/>
									</xsl:when>
									<xsl:otherwise>10</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:if test="$p>number($page)">
			<a href="#" onclick="{$method}({number($page)+1});return false;">下一页</a>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="loop">
	<xsl:param name="min"/>
	<xsl:param name="max"/>
	<xsl:if test="$max>=$min">
		<xsl:choose>
			<xsl:when test="number($min)=number($page)">
				<xsl:value-of select="$min"/>
			</xsl:when>
			<xsl:otherwise>
				<a href="#" onclick="{$method}({$min});return false;">[<xsl:value-of select="$min" />]</a>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:value-of select="number($min)+1"/>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:value-of select="$max"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>