<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="state"><xsl:value-of select="dataset/@st"/></xsl:variable>
<xsl:variable name="sort"><xsl:value-of select="dataset/@s"/></xsl:variable>
<xsl:variable name="page"><xsl:value-of select="dataset/@p"/></xsl:variable>
<xsl:variable name="size"><xsl:value-of select="dataset/@sz"/></xsl:variable>
<xsl:variable name="count"><xsl:value-of select="dataset/@c"/></xsl:variable>
<xsl:template match="/dataset/table">
<xsl:choose>
	<xsl:when test="count(row)>0">
		<div class="manager_topic_head">
			<div style="width:20px">顶</div>
			<div style="width:410px">标题</div>
			<div>更新日期</div>
		</div>
		<xsl:for-each select="row">
			<div>
				<xsl:attribute name="class">
					<xsl:choose>
						<xsl:when test="position() mod 2 = 1">manager_topic_body manager_topic_double</xsl:when>
						<xsl:otherwise>manager_topic_body</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<div style="width:20px">
					<xsl:choose>
						<xsl:when test="hometop = 'true'">首</xsl:when>
						<xsl:otherwise>
							<xsl:choose>
								<xsl:when test="sorttop = 'true'">栏</xsl:when>
								<xsl:otherwise>&#160;</xsl:otherwise>
							</xsl:choose>
						</xsl:otherwise>
					</xsl:choose>
				</div>
				<div style="width:410px">
					<a href="#" onclick="Manager.editTopic('{id}');return false;" title="{title}"><xsl:value-of select="title"/></a>
				</div>
				<div style="width:138px"><xsl:value-of select="lastupdate"/></div>
				<div>
					<a href="#" onclick="Manager.deleteTopic(this,'{id}',{$page});return false;">删除</a>
				</div>
			</div>
		</xsl:for-each>
	</xsl:when>
	<xsl:otherwise>
		<div class="manager_topic_null">还没有此类日志</div>
	</xsl:otherwise>
</xsl:choose>
	<xsl:if test="number($count)>number($size)">
		<div class="syblog_pager">
			<div class="syblog_pager_right_bar">
				<div class="syblog_pager_header_bar"><span class="left"></span><span class="right"></span></div>
					<div class="syblog_pager_content">
						<xsl:call-template name="pager">
							<xsl:with-param name="p">
								<xsl:value-of select="ceiling(number($count) div number($size))"/>
							</xsl:with-param>
						</xsl:call-template>
					</div>
				<div class="syblog_pager_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
			</div>
		</div>
	</xsl:if>
</xsl:template>
<xsl:template name="pager">
	<xsl:param name="p"/>
	<xsl:if test="$p>1">
		<xsl:if test="($page)>1">
			<a href="#" onclick="Manager.getTopicList({number($page)-1});return false;">上一页</a>
		</xsl:if>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:choose>
					<xsl:when test="$p>10 and $page>5">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:value-of select="number($page)-5"/>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="number($p)-10"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:choose>
					<xsl:when test="$p>10">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:choose>
									<xsl:when test="$page>5">
										<xsl:value-of select="number($page)+5"/>
									</xsl:when>
									<xsl:otherwise>10</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:if test="$p>number($page)">
			<a href="#" onclick="Manager.getTopicList({number($page)+1});return false;">下一页</a>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="loop">
	<xsl:param name="min"/>
	<xsl:param name="max"/>
	<xsl:if test="$max>=$min">
		<xsl:choose>
			<xsl:when test="number($min)=number($page)">
				<span>
					<xsl:value-of select="$min"/>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<a href="#" onclick="Manager.getTopicList({$min});return false;">[<xsl:value-of select="$min" />]</a>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:value-of select="number($min)+1"/>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:value-of select="$max"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>