<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="footer.xsl"/>
<xsl:variable name="host"><xsl:value-of select="document('host.xml',.)//conf/host"/></xsl:variable>
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
	<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="zh-CN">
		<xsl:call-template name="head" />
		<body>
			<input id="sycode_history_recorder" type="hidden"/>
			<xsl:call-template name="windows" />
			<div id="syblog_body" class="syblog_body">
				<xsl:call-template name="body" />
			</div>
			<xsl:call-template name="other" />
		</body>
	</html>
</xsl:template>
<xsl:template name="other">
	<script type="text/javascript">
	<![CDATA[
		setTimeout(function() {
			with($id("iframe_xml_http_request").contentWindow.location) {
				if(href == "about:blank") {
					if($id("sycode_history_recorder").value.length > 0) {
						href = $id("sycode_history_recorder").value;
					}
					else if(location.hash.length > 1) {
						href = decodeURIComponent(location.hash.trimLeft('#'));
					}
					else {
						href = "sort/0.aspx";
					}
				} else {
					href = href;
				}
			}
		}, 500);
		if(!document.XMLDocument) {
			var xmlhttp = new HTTPRequest();
			xmlhttp.send("main.xml",null,function(r) {
				window.docs.main = document.XMLDocument = r.getXML();
			});
		}
		else {
			window.docs.main = document.XMLDocument;
		}
		for(var i = 0;modules[i];i++) {
			modules[i].initialize();
		}
		var menu = $id("syblog_sort_menu");
		if(menu != null && !goMenu.current) {
			$(goMenu.current = menu.getElementsByTagName("a")[0]).appendClassName("current");
		}
	]]>
	</script>
</xsl:template>
<xsl:template name="head">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title><xsl:value-of select="head/title" /></title>
	<link rel="icon" type="image/x-icon" href="favicon.ico" />
	<link rel="stylesheet" type="text/css" href="ui/theme/{@theme}/skin/{@skin}/style.css" />
	<script type="text/javascript" src="js/lib.js"></script>
	<script type="text/javascript">
		var host = "<xsl:value-of select="$host" />";
		var modules = [];
		<![CDATA[
		window.docs = {};
		function goMenu(el) {
			if(goMenu.current != el) {
				if(goMenu.current != null) {
					goMenu.current.removeClassName("current");	
				}
				$(goMenu.current = el).appendClassName("current");
			}
		}
		function toggleDl(el) {
			if($(el.parentNode).hasClassName("hide_list")) {
				$(el.parentNode).removeClassName("hide_list");
			}
			else {
				$(el.parentNode).appendClassName("hide_list");
			}
		}
		function showResult(result,href,e) {
			$id("sycode_history_recorder").value = href;
			$id("syblog_main_content").innerHTML = result;
			$id("syblog_body").scrollTop = 0;
			if(e) {
				setTimeout(e, 100);
			}
		}
		function showAlbum(id, name, pics) {
			$("sycode_topic_comment_form").elements["id"].value = id;
			if(typeof(AlbumViewer) == "undefined") {
				ScriptLoader.Load("js/albumviewer.js",function() {
					AlbumViewer.initialize();
					AlbumViewer.show(id, name, pics);
				});
			}
			else {
				AlbumViewer.show(id, name, pics);
			}
		}
		function admin(q) {
			checklogin(
				function() {
					if(typeof(Manager) == "undefined") {
						with($id("syblog_manager_loader")) {
							style.display = "block";
							style.top = Math.max(document.documentElement.scrollTop + document.documentElement.offsetHeight / 2 - clientHeight / 2,0) + "px";
							style.left = Math.max(document.documentElement.scrollLeft + document.documentElement.offsetWidth / 2 - clientWidth / 2,0) + "px";
						}
						ScriptLoader.Load("js/manager.js",function(){
							Manager.initialize(q);
						});
					}
					else {
						$id("syblog_manager_frame").style.display = "block";
					}
				}
			);
		}
		function checklogin(callback) {
			if(Cookie.get("ticket")) {
				if(callback) {
					callback();
				}
			}
			else {
				readylogin(callback);
			}
		}
		function readylogin(callback) {
			with($id("syblog_bloger_login_frame")) {
				style.display = "block";
				style.top = Math.max(document.documentElement.scrollTop + document.documentElement.offsetHeight / 2 - clientHeight / 2,0) + "px";
				style.left = Math.max(document.documentElement.scrollLeft + document.documentElement.offsetWidth / 2 - clientWidth / 2,0) + "px";
			}
			login.callback = callback;
		}
		function login(f) {
			$(f).post(function(r){
				$id("syblog_bloger_login_frame").style.display = "none";
				f.reset();
				if(login.callback) {
					login.callback();
					login.callback = null;
				}
			});
		}
		function topicSearch(f) {
			if(f.elements["wd"].value.trim().length > 1) {
				if(window.isIE) {
					with(f.elements) {
						var d = "?p=1&sz=25&wd=" + encodeURIComponent(wd.value);
					}
					$id("iframe_xml_http_request").contentWindow.location.href = "search.aspx" + d;
				}
				else {
					f.submit();
				}
			}
		}
		function postComment(btn) {
			btn.disabled = true;
			$(btn.form).post(
				function(r) {
					btn.disabled = false;
					btn.form.getElementsByTagName("img")[0].src = "CRCImage.aspx?mod=comment&" + (new Date()).getTime();
					switch(r.getText()) {
						case '0':
							var comment = document.createElement("div");
							comment.className = "syblog_topic_comment";
							
							var right_bar = document.createElement("div");
							right_bar.className = "syblog_topic_comment_right_bar";
							comment.appendChild(right_bar);
							
							var header_bar = document.createElement("div");
							header_bar.className = "syblog_topic_comment_header_bar";
							header_bar.innerHTML = '<span class="left"></span><span class="right"></span>';
							right_bar.appendChild(header_bar);
							
							var content = document.createElement("div");
							content.className = "syblog_topic_comment_content";
							right_bar.appendChild(content);
							
							var comment_sign = document.createElement("div");
							comment_sign.className = "syblog_topic_comment_bloger";
							var regex = new RegExp("^https?://.+\\.\\w{2,}.*","gi");
							if(regex.test(btn.form.elements["site"].value.trim())) {
								var link = document.createElement("a");
								link.target = "_blank";
								link.href = btn.form.elements["site"].value.trim();
								link.innerText = (btn.form.elements["sign"].value.trim().length  > 0 ? btn.form.elements["sign"].value.trim() : "匿名");
								comment_sign.appendChild(link);
							} else {
								comment_sign.innerText = (btn.form.elements["sign"].value.trim().length  > 0 ? btn.form.elements["sign"].value.trim() : "匿名");
							}
							content.appendChild(comment_sign);
							
							var comment_body = document.createElement("div");
							comment_body.className = "syblog_topic_comment_body";
							content.appendChild(comment_body);							
							
							var comment_time = document.createElement("div");
							comment_time.innerHTML = (new Date()).toLocaleString();
							comment_body.appendChild(comment_time);
							
							var comment_content = document.createElement("pre");
							comment_content.innerText = btn.form.elements["content"].value;
							comment_body.appendChild(comment_content);
							
							var footer_bar = document.createElement("div");
							footer_bar.className = "syblog_topic_comment_footer_bar footer_bar";
							footer_bar.innerHTML = '<span class="left"></span><span class="right"></span>';
							right_bar.appendChild(footer_bar);
							
							with($id("sycode_topic_comment")) {
								if(childNodes.length == 1) {
									appendChild(document.createElement("div"));
								}
								firstChild.nextSibling.appendChild(comment);
							}
							btn.form.reset();
							break;
						case '1':
							alert("评论失败.");
							break;
						case '2':
							alert("评论过程出现异常.");
							break;
						case '3':
							alert("验证码错误.");
							break;
						default:
							alert("发生未知错误");
							break;
					}
				},
				function(r) {
					btn.disabled = false;
				}
			);
		}
		function postLeave(btn) {
			btn.disabled = true;
			$(btn.form).post(
				function(r) {
					btn.disabled = false;
					btn.form.getElementsByTagName("img")[0].src = "CRCImage.aspx?mod=leave&" + (new Date()).getTime();
					switch(r.getText()) {
						case '0':
							var leave_list = $id("syblog_module_leave_list");
							leave_list.parentNode.parentNode.style.display = "block";
							var leave = document.createElement("li");
							var sign = document.createElement("div");
							var regex = new RegExp("^https?://.+\\.\\w{2,}.*","gi");
							if(regex.test(btn.form.elements["site"].value.trim())) {
								var link = document.createElement("a");
								link.target = "_blank";
								link.href = btn.form.elements["site"].value.trim();
								link.innerText = (btn.form.elements["sign"].value.trim().length  > 0 ? btn.form.elements["sign"].value.trim() : "匿名");
								sign.appendChild(link);
							} else {
								sign.innerText = (btn.form.elements["sign"].value.trim().length  > 0 ? btn.form.elements["sign"].value.trim() : "匿名");
							}
							leave.appendChild(sign);
							var content = document.createElement("span");
							content.innerText = btn.form.elements["content"].value;
							leave.appendChild(content);
							if(leave_list.getElementsByTagName("li").length == 0) {
								leave_list.innerHTML = "";
							}
							leave_list.appendChild(leave);
							
							btn.form.reset();
							break;
						case '1':
							alert("留言失败.");
							break;
						case '2':
							alert("留言过程出现异常.");
							break;
						case '3':
							alert("验证码错误.");
							break;
						default:
							alert("发生未知错误");
							break;
					}
				},
				function(r) {
					btn.disabled = false;
				}
			);
		}
		function showTopicItem(obj, sibling) {
			if(!$(obj).hasClassName("curren")) {
				with(obj) {
					appendClassName("curren");
					$id(getAttribute("for")).style.display = "block";
				}
				with($(obj[sibling])) {
					removeClassName("curren");
					$id(getAttribute("for")).style.display = "none";					
				}
			}
		}
		
		function commentPage(obj, topic, page, max) {
			if(!window.docs.commentXsl) {
				var xmlhttp = new HTTPRequest();
				xmlhttp.send("ui/common/comment.xsl",null,function(r) {
					window.docs.commentXsl = r.getXML();
					commentPage(obj, topic, page, max);
				});
			}
			else {
				var xmlhttp = new HTTPRequest();
				xmlhttp.send("topic/" + topic + "/" + page + ".xml",null,function(r) {
					if(window.isIE) {
						$id("syblog_body").scrollTop += $("sycode_topic_comment").getPosition().y;
					} else  {
						$id("syblog_body").scrollTop = $("sycode_topic_comment").getPosition().y;
					}
					$("sycode_topic_comment").firstChild.nextSibling.innerHTML = r.getXML().transformNode(window.docs.commentXsl.documentElement).replace(/_src="/gmi, 'src="');
				});
				var start = Math.max(page - 5, 1);
				var end = Math.min(start + 5,max);
				function appendItem(pager, p, txt) {
					pager.push('<a href="#" onclick="commentPage(this,\'');
					pager.push(topic);
					pager.push("',");
					pager.push(p);
					pager.push(',');
					pager.push(max);
					pager.push(');return false;">');
					pager.push(txt);
					pager.push('</a>');
				}
				var pager = [];
				if(page > 1) {
					appendItem(pager, page - 1, "上一页");
				}
				for(var i = start;i <= end;i++) {
					if(i == page) {
						pager.push("<span>");
						pager.push(i);
						pager.push("</span>");
					}
					else {
						appendItem(pager, i , "[" + i + "]");
					}
				}
				if(page < max) {
					appendItem(pager, page + 1,"下一页");
				}
				obj.parentNode.innerHTML = pager.join('');
			}
		}
		function hightLight() {
			if(typeof(Highlighter) == "undefined") {
				ScriptLoader.Load("js/highlighter.js",hightLight);
			}
			else {
				Highlighter.Batch($id("sycode_topic_body"));
				if(window.isIE) {
					CollectGarbage();
				}
			}
		}
		]]>
	</script>
</head>
</xsl:template>
<xsl:template name="title">
	<div class="syblog_sitetitle">
		<b><xsl:value-of select="head/title" /></b>
		<div>
			<a href="{$host}"><xsl:value-of select="$host" /></a>
			<a href="#">
				<xsl:attribute name="onclick">
					window.clipboardData.setData("Text", "<xsl:value-of select="$host" />");
					return false;
				</xsl:attribute>
				<xsl:text>复制</xsl:text>
			</a>
			<xsl:if test="system-property('xsl:vendor')!='Transformiix'">
				<a href="#">
					<xsl:attribute name="onclick">
						window.external.addFavorite("<xsl:value-of select="$host" />","<xsl:value-of select="head/title" />");
						return false;
					</xsl:attribute>
					<xsl:text>收藏</xsl:text>
				</a>
			</xsl:if>
		</div>
	</div>
	<div class="syblog_subtitle"><xsl:value-of select="head/meta[@name='description']/@content" /></div>
</xsl:template>
<xsl:template match="html/body/a[@id='custom']">
	<xsl:if test="string-length(normalize-space(.))>0">
		<dl class="syblog_module_custom">
			<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
			<dd class="syblog_list_item">
				<div class="syblog_module_custom_container">
					<xsl:choose>
						<xsl:when test="system-property('xsl:vendor')='Transformiix'">
							<div id="syblog_transformiix">
								<xsl:value-of select="." />
							</div>
							<script language="javascript">
								<![CDATA[
								var st = document.getElementById("syblog_transformiix");
								var script = "";
								var sc = st.firstChild.textContent.replace(/([\s\S]*?)(<script[^>]*?>[\s\S]*?<\/script>)/gmi, function(match, $1, $2) {
									script += '<script language="javascript">document.write("' + $1.replace(/\"/gm, '\\\"').replace(/\r|\n/gm, '') + '")</script>' + $2;
									return "";
								});
								script += '<script language="javascript">document.write("' + sc.replace(/\"/gm, '\\\"').replace(/\r|\n/gm, '') + '")</script>';
								
								var im = document.createElement("iframe");
								st.appendChild(im);
								var d = im.contentDocument;
								var html = "";
								var func = "__" + Math.floor(90000000 * Math.random() + 10000000);
								window[func] = function() {
									im.src = "about:blank";
									st.removeChild(im);
									var cc = st.parentNode.parentNode;
									var c = document.createElement("div");
									c.className = "syblog_module_custom_container";
									c.innerHTML = html;
									cc.innerHTML = "";
									setTimeout(function() {
										cc.appendChild(c);
									}, 1000);
								}
								d._write = d.write;
								d.write = function(a) {
									html += a;
								}
								d._write('<html><head><title>' + document.title + '</title></head><body>' + script + '</body><script language="javascript">parent.' + func + '()</script></html>');
								
								]]>
							</script>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of disable-output-escaping="yes" select="." />
						</xsl:otherwise>
					</xsl:choose>
				</div>
			</dd>
			<dd class="syblog_list_footer"></dd>
		</dl>
	</xsl:if>
</xsl:template>
<xsl:template match="html/body/a[@id='sort']">
	<dl class="syblog_module_sort">
		<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
		<dd class="syblog_list_item">
			<ul>
				<xsl:for-each select="document('../../mysort.xml')//html/body/a">
					<li id="syblog_sort_menu">
						<a onclick="goMenu(this)" target="iframe_xml_http_request" href="{@href}"><xsl:value-of select="." /></a>
					</li>
				</xsl:for-each>
			</ul>
		</dd>
		<dd class="syblog_list_footer"></dd>
	</dl>
</xsl:template>
<xsl:template match="html/body/a[@id='collection']">
	<dl class="syblog_module syblog_module_collection">
		<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
		<dd class="syblog_list_item">
			<ul>
				<xsl:for-each select="document('../../collection.xml')//html/body/a">
					<li>
						<a target="iframe_xml_http_request" href="{@href}"><xsl:value-of select="." /></a>
					</li>
				</xsl:for-each>
			</ul>
		</dd>
		<dd class="syblog_list_footer"></dd>
	</dl>
</xsl:template>
<xsl:template match="html/body/a[@id='comment']">
	<xsl:if test="count(document('../../comment.xml')//html/body/a)>0">
		<dl class="syblog_module syblog_module_comment">
			<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
			<dd class="syblog_list_item">
				<ul>
				<xsl:for-each select="document('../../comment.xml')//html/body/a">
					<li>
						<div>
							<span>
								<xsl:choose>
									<xsl:when test="string-length(@site)>0">
										<a target='_blank' href="{@site}"><xsl:value-of select="@name" /></a>
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="@name" />
									</xsl:otherwise>
								</xsl:choose>
							</span>
						</div>
						<a target='iframe_xml_http_request' class='syblog_comment_link pre' href="topic/{@id}/"><xsl:value-of select="." /></a>
					</li>
				</xsl:for-each>
				</ul>
			</dd>
			<dd class="syblog_list_footer"></dd>
		</dl>
	</xsl:if>
</xsl:template>
<xsl:template match="html/body/a[@id='leaveboard']">
	<dl class="syblog_module_leave_board">
		<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
		<dd class="syblog_list_item">
			<form action="PostLeave.aspx" onsubmit="return false">
				<div>署名：<input maxlength="16" type="text" class="sign" name="sign"/></div>
				<div>主页：<input maxlength="255" type="text" class="sign" name="site" value="http://"/></div>
				<div>方式：
					<input type="radio" name="public" value="true" checked="true" id="syblof_leave_public" /><label for="syblof_leave_public">公开</label>
					<input type="radio" name="public" value="false" id="syblof_leave_private" /><label for="syblof_leave_private">密语</label>
				</div>
				<div>验证：<input maxlength="5" min="5" max="5" msg="必须输入验证码" type="text" class="crcode" name="crcode" style="ime-mode:disabled"/>
					<img class="crcimg" onclick="this.src='CRCImage.aspx?mod=leave&amp;' + (new Date()).getTime()" src="CRCImage.aspx?mod=leave&amp;{generate-id(.)}" />
				</div>
				<div>内容：<textarea name="content" min="1" msg="必须输入留言内容"></textarea></div>
				<div class="syblog_module_leave_board_btn"><button name="submit" onclick="postLeave(this)">发表留言</button></div>
			</form>
		</dd>
		<dd class="syblog_list_footer"></dd>
	</dl>
</xsl:template>
<xsl:template match="html/body/a[@id='leave']">
	<dl class="syblog_module syblog_module_leave">
		<xsl:if test="count(document('../../lastleave.xml')//html/body/a)=0">
			<xsl:attribute name="style">display:none</xsl:attribute>
		</xsl:if>
		<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
		<dd class="syblog_list_item">
			<ul id="syblog_module_leave_list">
			<xsl:for-each select="document('../../lastleave.xml')//html/body/a">
				<li>
					<div>
						<span>
							<xsl:choose>
								<xsl:when test="string-length(@href)>0">
									<a target='_blank' href="{@href}"><xsl:value-of select="@name" /></a>
								</xsl:when>
								<xsl:otherwise>
									<xsl:value-of select="@name" />
								</xsl:otherwise>
							</xsl:choose>
						</span>
					</div>
					<span class="pre">
						<xsl:value-of select="." />
					</span>
				</li>
			</xsl:for-each>
			</ul>
		</dd>
		<dd class="syblog_list_footer"></dd>
	</dl>
</xsl:template>
<xsl:template match="html/body/a[@id='link']">
	<xsl:if test="count(document('../../link.xml')//html/body/a)>0">
		<dl class="syblog_module syblog_module_link">
			<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
			<dd class="syblog_list_item">
				<ul>
					<xsl:for-each select="document('../../link.xml')//html/body/a">
						<xsl:sort select="position()" order="descending" data-type="number" />
						<li>
							<a target="_blank" href="{@href}"><xsl:value-of select="." /></a>
						</li>
					</xsl:for-each>
				</ul>
			</dd>
			<dd class="syblog_list_footer"></dd>
		</dl>
	</xsl:if>
</xsl:template>
<xsl:template match="html/body/a[@id='stat']">
	<dl class="syblog_module syblog_module_stat">
		<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
		<dd class="syblog_list_item">
			<xsl:apply-templates select="document('../../stat.aspx')//stat"/>
		</dd>
		<dd class="syblog_list_footer"></dd>
	</dl>
</xsl:template>
<xsl:template match="stat">
	<ul>
		<li>访问统计：<xsl:value-of select="row[@field='viewcount']" /></li>
		<li>总日志数：<xsl:value-of select="row[@field='topic']" /></li>
		<li>日志评论：<xsl:value-of select="row[@field='comment']" /></li>
		<li>引用统计：<xsl:value-of select="row[@field='trackback']" /></li>
		<li>总相册数：<xsl:value-of select="row[@field='album']" /></li>
		<li>相册评论：<xsl:value-of select="row[@field='albumcomment']" /></li>
		<li>总留言数：<xsl:value-of select="row[@field='leave']" /></li>
	</ul>
</xsl:template>
<xsl:template match="html/body/a[@id='store']">
	<xsl:if test="count(document('../../store.xml')//html/body/a)>0">
		<dl class="syblog_module syblog_module_history">
			<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
			<dd class="syblog_list_item">
				<ul>
					<xsl:for-each select="document('../../store.xml')//html/body/a">
						<xsl:sort select="position()" order="descending" data-type="number" />
						<li>
							<a target="iframe_xml_http_request" href="{@href}"><xsl:value-of select="@id" />年<xsl:value-of select="@name" />月&#160;（<xsl:value-of select="." />）</a>
						</li>
					</xsl:for-each>
				</ul>
			</dd>
			<dd class="syblog_list_footer"></dd>
		</dl>
	</xsl:if>
</xsl:template>
<xsl:template match="html/body/a[@id='album']">
	<dl class="syblog_module_album">
		<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
		<dd class="syblog_list_item">
			<div class="syblog_module_album">
        <div class="syblog_album_class_lst">
          <div>/0</div><div>0</div>
          <a href="#" class="hide_list" id="syblog_album_class_lst"><p></p><ul></ul></a>
        </div>
				<div class="syblog_slide_container" alt="正在加载{@title}...">
					<img id="syblog_slide_container" />
				</div>
				<div id="syblog_slide_control_container">
					<a title="pause" class="pause"></a>
					<a title="back" class="back"></a>
					<a title="foward" class="foward"></a>
					<a title="打开相册" class="full" target="iframe_xml_http_request" href="album.xml"></a>
				</div>
			</div>
			<script type="text/javascript">
			<![CDATA[
				modules.push(syblog_slide={
					pics: [],
					current: -1,
					currentNode:null,
					paused: false,
					groupList: null,
					stateBox: null,
					countBox: null,
					currentBox: null,
					container: null,
					initialize: function(){
						this.groupList = $("syblog_album_class_lst");
						
						var flags = this.groupList.parentNode.getElementsByTagName('div');
						this.countBox = flags[0];
						this.currentBox = flags[1];
						
						(this.container = $("syblog_slide_container")).style.filter="revealtrans(duration=0.5,transition=25)";
						var cc = $("syblog_slide_control_container");
						this.stateBox = cc.getElementsByTagName('span')[0];
						
						var btns = cc.getElementsByTagName("a");
						this.playButton = btns[0];
						btns[0].onclick = this.play.bind(this);
						btns[1].onclick = this.back.bind(this);
						btns[2].onclick = this.foward.bind(this);
						
						var xmlhttp = new HTTPRequest(true,true,false);
						xmlhttp.send(
							"album.xml",
							null,
							function(r) {
								window.docs.album = r.getXML();
								var albums = window.docs.album.documentElement.selectNodes("body/a");
								with($(this.groupList.lastChild))
								{
									for(var i = 0;i < albums.length;i++)
									{
										if(albums[i].selectNodes("img").length > 0) {
											var album = document.createElement("li");
											album.node = albums[i];
											album.innerText = album.node.getAttribute("name");
											appendChild(album);
										}
									}
									if(childNodes.length > 0) {
										firstChild.className = "current";
										this.update(this.currentNode = firstChild);
										this.onfoward();
										setInterval(this.processor.bind(this),5000);
										document.attachEvent("onmouseup",function(){
											if(!this.groupList.contains(event.srcElement)) {
												this.groupList.appendClassName("hide_list");
											}
										}.bind(this));
										this.groupList.onclick = function() {
											toggleDl(this.groupList.firstChild);
											if(event.srcElement.tagName == "LI") {
												this.currentNode.className = "";
												this.update(this.currentNode = event.srcElement);
												this.currentNode.className = "current";
												
											}
										}.bind(this);
									}
									else  {
										parentNode.parentNode.parentNode.parentNode.parentNode.style.display = "none";
									}
								}
							}.bind(this)
						);
					},
					getPic: function(n){
						if((this.current = this.current + n) < 0)
						{
							this.current = this.pics.length - 1;
						}
						this.current = this.current % this.pics.length;
						this.currentBox.innerHTML = this.current + 1;
						return this.pics[this.current = this.current % this.pics.length];
					},
					play: function(){
						this.paused = !this.paused;
						with(this.playButton) {
							className = title = this.paused ? "play" : "pause";
						}
					},
					pause: function(){
						this.paused = true;
						with(this.playButton) {
							className = title =  "play";
						}
					},
					back: function(){
						this.pause();
						this.onback();
					},
					onback: function(){
						this.switchPic(this.getPic(-1));
					},
					foward: function(){
						this.pause();
						this.onfoward();
					},
					onfoward: function(){
						this.switchPic(this.getPic(1));
					},
					switchPic: function(pic){
						with(this.container)
						{
							if(window.isIE) {
								with(filters[0]) {
									apply();
									transition = 25;
									play();
								}
							}
							src = pic.src;
							alt = title = pic.alt
						}
					},
					update: function(album) {
						this.current = -1;
						this.pics = [];
						var nodes = album.node.selectNodes('img');
						this.groupList.firstChild.innerText = album.innerText;
						this.countBox.innerHTML = "/" + nodes.length;
						for(var i = 0;i < nodes.length;i++){
							this.pics.push({src:"album/thumb/" + nodes[i].getAttribute("src"),alt:nodes[i].getAttribute("alt")});
						}
						if(this.paused) {
							this.onfoward();
						}
					},
					processor: function() {
						if(!this.paused) {
							this.onfoward();
						}
					}
				});
			]]>
			</script>
		</dd>
		<dd class="syblog_list_footer"></dd>
	</dl>
</xsl:template>
<xsl:template match="html/body/a[@id='calendar']">
	<dl class="syblog_module_calendar">
		<dt onclick="toggleDl(this)"><span><xsl:value-of select="@title" /></span></dt>
		<dd class="syblog_list_item">
			<div class="syblog_calendar_container">
				<div id="syblog_calendar_control">
					<a title="上一年" class="previousyear"></a>
					<a title="上一月" class="previousmonth"></a>
					<a class="link">loading</a>
					<a title="下一月" class="nextmonth"></a>
					<a title="下一年" class="nextyear"></a>
				</div>
				<div id="syblog_calendar_week_box">
					<div>日</div>
					<div>一</div>
					<div>二</div>
					<div>三</div>
					<div>四</div>
					<div>五</div>
					<div>六</div>
				</div>
				<div id="syblog_calendar_day_box"></div>
			</div>
		</dd>
		<dd class="syblog_list_footer"></dd>
	</dl>
	<script type="text/javascript">
	<![CDATA[
		﻿modules.push(syblog_calendar={
			cache:{},
			today:{year:0,month:0,day:0},
			nowDataContainer:null,
			nowDateBox:null,
			currentYear:null,
			currentMonth:null,
			initialize: function(){
				var xmlhttp = new HTTPRequest(true,true,true);
				xmlhttp.send("store.xml", null, function(r) {
					window.docs.store = r.getXML();
					var btns = $id("syblog_calendar_control").getElementsByTagName("a");
					 btns[0].onclick = this.previousYear.bind(this);
					 btns[1].onclick = this.previousMonth.bind(this);
					 btns[3].onclick = this.nextMonth.bind(this);
					 btns[4].onclick = this.nextYear.bind(this);
					 
					this.nowDateBox = btns[2];
					
					this.nowDataContainer = $id("syblog_calendar_day_box");
			
					var now = new Date();
					with(this.today) 
					{
						year = now.getFullYear();
						month = now.getMonth();
						day = now.getDate();
					}		
					
					this.getIndex(this.today.year,this.today.month);
				}.bind(this));
			},
			previousYear : function(){
				this.getIndex(this.currentYear - 1,this.currentMonth);
			},
			previousMonth : function(){
				this.getIndex(this.currentYear,this.currentMonth - 1);
			},
			nextYear : function(){
				this.getIndex(this.currentYear + 1,this.currentMonth);
			},
			nextMonth : function(){
				this.getIndex(this.currentYear,this.currentMonth + 1);
			},
			getIndex: function(y,m) {
				if(m < 0){
					y--;
					m = 11;
				}
				if(m > 11) {
					y++;
					m = 0;
				}
				
				var node = window.docs.store.documentElement.selectSingleNode("body/a[@id='" + y + "' and @name='" + (m + 1) + "']");
				if(node) {
					this.fillDay(y,m,node.getAttribute("index").toArray());
				}
				else {
					this.fillDay(y,m,"0000000000000000000000000000000".toArray());
				}
			},
			fillDay: function(y,m,flag) {
				this.currentYear = y;
				this.currentMonth = m;
				var day = this.padLeft(y,m);
				var dat = [];
				for(var i = 0;i < day;) {
					if(flag[i] == 1) {
						dat.push("<div" + ((this.today.day == ++i && this.today.year == y && this.today.month == m) ? " class='today'" : "") + "><a href='store/{0}/{1}/{2}.aspx' target='iframe_xml_http_request'>".format(y,m + 1,i) + i + "</a></div>");
					}
					else
					{
						dat.push("<div" + ((this.today.day == ++i && this.today.year == y && this.today.month == m) ? " class='today'" : "") + ">" + i + "</div>");
					}
				}
				this.nowDataContainer.innerHTML += dat.join("");
				this.nowDateBox.innerHTML = y + "年" + (m + 1) + "月";
			},
			padLeft: function(y,m) {
				var date = new Date(y,m,1);
				var day = [31,28,31,30,31,30,31,31,30,31,30,31][m];
				if(m == 1 && ((y % 4 == 0 && y % 100 > 0) || y % 400 == 0)) {
					mday=29;
				}
				var pad = [];
				for(var i = 0;i < date.getDay();i++) {
					pad.push("<div></div>");
				}
				this.nowDataContainer.innerHTML = pad.join("");
				return day;
			}
		});
	]]>
	</script>
</xsl:template>
<xsl:template name="rss">
	<div class="syblog_rss_link_container">
		<div class="syblog_rss_link_right_bar">
			<div class="syblog_rss_link_header_bar"><span class="left"></span><span class="right"></span></div>
			<div class="syblog_rss_link_content">
				<a target="_blank" href="http://www.xianguo.com/subscribe.php?url={$host}rss.aspx">
					<img src="ui/img/rss_xianguo.jpg" title="订阅到鲜果" alt="订阅到鲜果" />
				</a>
				<a target="_blank" href="http://fusion.google.com/add?feedurl={$host}rss.aspx">
					<img src="ui/img/rss_google.gif" title="订阅到Google" alt="订阅到Google" />
				</a>
				<a target="_blank" href="http://www.zhuaxia.com/add_channel.php?url={$host}rss.aspx">
					<img src="ui/img/rss_zhuaxia.gif" title="订阅到抓虾" alt="订阅到抓虾" />
				</a>
				<a target="_blank" href="http://www.bloglines.com/sub/{$host}rss.aspx">
					<img src="ui/img/rss_bloglines.gif" title="订阅到bloglines" alt="订阅到bloglines" />
				</a>
				<a target="_blank" href="http://add.my.yahoo.com/rss?url={$host}rss.aspx">
					<img src="ui/img/rss_yahoo.gif" title="订阅到Yahoo" alt="订阅到Yahoo" />
				</a>
				<a target="_blank" href="http://rss.gougou.com/find_rss.jsp?url={$host}rss.aspx">
					<img src="ui/img/rss_gougou.gif" title="订阅到GouGou" alt="订阅到GouGou" />
				</a>
				<a target="_blank" href="http://www.pageflakes.com/subscribe.aspx?url={$host}rss.aspx">
					<img src="ui/img/rss_pageflakes.gif" title="订阅到飞鸽" alt="订阅到飞鸽" />
				</a>
				<a target="_blank" href="http://www.rojo.com/add-subscription?resource={$host}rss.aspx">
					<img src="ui/img/rss_rojo.gif" title="订阅到Rojo" alt="订阅到Rojo"/>
				</a>
				<a target="_blank" href="http://www.newsgator.com/ngs/subscriber/subfext.aspx?url={$host}rss.aspx">
					<img src="ui/img/rss_newsgator.gif" title="订阅到newsgator" alt="订阅到newsgator" />
				</a>
				<a target="_blank" href="http://www.netvibes.com/subscribe.php?url={$host}rss.aspx">
					<img src="ui/img/rss_netvibes.gif" title="订阅到netvibes" alt="订阅到netvibes" />
				</a>
				<a target="_blank" href="http://www.anothr.com/add?url={$host}rss.aspx">
					<img src="ui/img/rss_anothr.gif" title="订阅到anothr" alt="订阅到anothr" />
				</a>
				<a target="_blank" href="http://sofa.souyo.com/add?f={$host}rss.aspx">
					<img src="ui/img/rss_souyo.gif" title="订阅到沙发" alt="订阅到沙发" />
				</a>
				<a target="_blank" href="http://www.feedou.com/addchannelservlet?commandkey=takersslog&amp;url={$host}rss.aspx">
					<img src="ui/img/rss_feedou.gif" title="订阅到飞豆" alt="订阅到飞豆" />
				</a>
				<a target="_blank" href="rss.aspx">
					<img src="ui/img/rss2.gif" alt="RSS 2.0" title="RSS 2.0" />
				</a>
			</div>
			<div class="syblog_rss_link_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	</div>
</xsl:template>
<xsl:template name="menu">
	<div class="syblog_menu_frame">
		<div class="syblog_menu_right_bar">
			<div class="syblog_menu_header_bar"><span class="left"></span><span class="right"></span></div>
			<div class="syblog_menu_content">
				<span class="syblog_tag_button">
					<a target="iframe_xml_http_request" href="Tags.aspx">标签</a>
				</span>
				<span class="syblog_album_button">
					<a target="iframe_xml_http_request" href="Album.xml">相册</a>
				</span>
				<span class="syblog_leave_button">
					<a target="iframe_xml_http_request" href="Leave.aspx">留言</a>
				</span>
				<span class="syblog_friend_button">
					<a href="#" onclick="admin();return false;">管理</a>
				</span>
			</div>
			<div class="syblog_menu_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	</div>
</xsl:template>
<xsl:template name="search">
	<div class="syblog_search_form">
		<form id="syblog_search_form" target="iframe_xml_http_request" method="GET" action="search.aspx" onsubmit="topicSearch(this);return false;">
			<div class="syblog_search_bar_container">
				<div class="syblog_search_bar_right_bar">
					<div class="syblog_search_bar_header_bar"><span class="left"></span><span class="right"></span></div>
						<div id="syblog_search_bar_container">
							<input type="hidden" name="p" value="1" />
							<input type="hidden" name="sz" value="25" />
							<input type="text" name="wd" maxlength="20" />
							<a href="#" title="搜索" onclick="return false"><input value="" id="syblog_search_button" type="submit" onclick="if(!(event.cancelBubble=window.isIE))topicSearch(this.form)"/></a>
						</div>
					<div class="syblog_search_bar_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
				</div>
			</div>
		</form>
	</div>
</xsl:template>
<xsl:template name="main">
	<div id="syblog_main_frame">
		<div class="syblog_main_right_bar">
			<div class="syblog_main_header_bar"><span class="left"></span><span class="right"></span></div>
			<div id="syblog_main_content"></div>
			<div class="syblog_main_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	</div>
</xsl:template>
<xsl:template name="channel">
	<div class="syblog_bloger_channel">
		<div class="syblog_bloger_photo">
			<img src="{head/meta[@name='author']/@head}" />
		</div>
		<div class="syblog_bloger_name">
			<a target="iframe_xml_http_request" href="info.xml"><xsl:value-of select="head/meta[@name='author']/@content" /></a>
		</div>
	</div>
</xsl:template>
<xsl:template name="windows">
	<script type="text/javascript">
		var xml_http_request_iframe = document.createElement("iframe");
		with(xml_http_request_iframe) {
			id = name = "iframe_xml_http_request";
			width="0";
			height="0";
			style.display = "none";
			src="about:blank";
		}
		document.getElementsByTagName("body")[0].appendChild(xml_http_request_iframe);
		if(window.isIE) {
			document.attachEvent("onclick",function(){
				if(event.srcElement.tagName == "A" &amp;&amp; event.srcElement.target.toLowerCase() == "iframe_xml_http_request") {
					if(xml_http_request_iframe.contentWindow.location.href != event.srcElement.href)
						xml_http_request_iframe.contentWindow.location.href = event.srcElement.href;
					return event.returnValue = !(event.cancelBubble = true);
				}
			});
		}
	</script>
	<div id="syblog_bloger_login_frame" class="syblog_window">
		<div class="syblog_login_right_bar syblog_window_right_bar">
			<a class="syblog_window_close_button" href="#" onclick="$id('syblog_bloger_login_frame').style.display='none';return false"></a>
			<div class="syblog_window_title" id="syblog_login_header_bar"><span class="left"></span><span>管理登录</span><span class="right"></span></div>
			<div class="syblog_window_body">
				<form id="syblog_login_form" action="Login.aspx" onsubmit="return false">
					<div class="syblog_login_pop">请输入管理密码</div>
					<div><span>密　码：</span><input type="password" onkeypress="if(event.keyCode==13)login(this.form)" name="pwd" min="5" max="32" msg="您输入的密码不正确" /></div>
					<div class="syblog_login_button"><input type="button" onclick="login(this.form)" value="登录" /></div>
				</form>
			</div>
			<div class="syblog_window_footer"><span class="left"></span><span class="right"></span></div>
		</div>
		<div class="syblog_bloger_login_frame_shadow syblog_window_shadow"><iframe></iframe></div>
	</div>
	<script type="text/javascript">$("syblog_login_header_bar").bindDragTo($id("syblog_bloger_login_frame"));</script>
	<div id="syblog_manager_loader" class="syblog_window">
		<div class="syblog_window_right_bar syblog_manager_loader_right_bar">
			<div class="syblog_window_body syblog_manager_loader_body">
				<div><span id="syblog_manager_loader_text">正在加载管理脚本，请稍候……&#160;</span><img src="ui/img/loading1.gif"/></div>
			</div>
			<div class="syblog_window_footer"><span class="left"></span><span class="right"></span></div>
		</div>
		<div class="syblog_window_shadow syblog_manager_loader_shadow"><iframe></iframe></div>
	</div>
	<div id="syblog_manager_frame"></div>
</xsl:template>
</xsl:stylesheet>