<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="host"><xsl:value-of select="document('../../host.xml')//conf/host"/></xsl:variable>
<xsl:variable name="page"><xsl:value-of select="html/@page"/></xsl:variable>
<xsl:variable name="wd"><xsl:value-of select="html/head/meta[@name='keywords']/@content"/></xsl:variable>
<xsl:variable name="size"><xsl:value-of select="html/@size"/></xsl:variable>
<xsl:variable name="url">search.aspx?wd=<xsl:value-of select="html/@code" />&amp;sz=<xsl:value-of select="$size" />&amp;p=</xsl:variable>
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8" />
<xsl:template match="/html">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	  	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><xsl:value-of select="$wd"/></title>
	  	<script type="text/javascript">
		  	if(typeof(parent.showResult)!="function") {
		  		location.replace("./#search.aspx" + encodeURIComponent(location.search));
		  	}
			var words = document.title.toLowerCase().split(/\s+/);
			function highlightWord(node,word) {
				if (node.hasChildNodes) {
					for (var i = 0;i != node.childNodes.length;i++) {
						highlightWord(node.childNodes[i],word);
					}
				}
				if (node.nodeType == 3) {
					var nodeVal = node.nodeValue.toLowerCase();
					if (nodeVal.indexOf(word) != -1) {
						var pn = node.parentNode;
						if (pn.getAttribute("class") != "keyword") {
							var nv = node.nodeValue;
							var ni = nodeVal.indexOf(word);
							var before = document.createTextNode(nv.substr(0,ni));
							var docWordVal = nv.substr(ni,word.length);
							var after = document.createTextNode(nv.substr(ni+word.length));
							var hiword = document.createElement("span");
							hiword.setAttribute("class","keyword");
							hiword.appendChild(document.createTextNode(docWordVal));
							pn.insertBefore(before,node);
							pn.insertBefore(hiword,node); 
							pn.insertBefore(after,node);
							pn.removeChild(node);
						}
					}
				}
			}
			window.onload = function() {
				var nodes = document.getElementById("syblog_search_result_content").getElementsByTagName("label");
				for(var i=0;i != nodes.length;i++) {
					for(var j=0;j != words.length;j++) {
						highlightWord(nodes[i],words[j]);
					}
				}
				parent.showResult(document.getElementById("output").innerHTML,location.href);
			}
		</script>
	</head>
	<body><div id="output">
		<div class="syblog_search">
			<div class="syblog_search_right_bar">
				<div class="syblog_search_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
				<div class="syblog_search_content">
					<div class="syblog_search_stat">
						<div class="syblog_search_stat_right_bar">
							<div class="syblog_search_stat_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
							<div class="syblog_search_stat_content">
								找到相关日志<span><xsl:value-of select="format-number(body/@count,'###,###,##0')" /></span>篇
							</div>
							<div class="syblog_search_stat_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
						</div>
					</div>
					<xsl:if test="number(body/@count)=0">
						<p><b>抱歉，没有找到与“<span class="keyword"><xsl:value-of select="$wd" /></span>” 相关的日志。 </b></p>
					</xsl:if>
					<div class="syblog_search_result">
						<div class="syblog_search_result_right_bar">
							<div class="syblog_search_result_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
							<div id="syblog_search_result_content">
								<xsl:apply-templates select="body/p"/>
							</div>
							<div class="syblog_search_result_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
						</div>
					</div>
				</div>
				<div class="syblog_search_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
			</div>
		</div>
		<xsl:if test="number(@count)>number($size)">
			<div class="syblog_pager">
				<div class="syblog_pager_right_bar">
					<div class="syblog_pager_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
					<div class="syblog_pager_content">
						<xsl:call-template name="pager">
							<xsl:with-param name="p">
								<xsl:value-of select="ceiling(number(@count) div number($size))"/>
							</xsl:with-param>
						</xsl:call-template>
					</div>
					<div class="syblog_pager_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
				</div>
			</div>
		</xsl:if>
	</div></body>
</html>
</xsl:template>
<xsl:template match="body/p">
	<div class="syblog_search_topic">
		<div class="syblog_search_topic_right_bar">
			<div class="syblog_search_topic_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
			<div class="syblog_search_topic_content">
				<label>
					<a target="iframe_xml_http_request" href="{a/@href}">
						<xsl:if test="system-property('xsl:vendor')!='Transformiix'">
							<xsl:attribute name="onclick">
								$id("iframe_xml_http_request").contentWindow.location.href=this.href;return false;
							</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="a" />
					</a>
				</label>
				<div>
					<label><xsl:value-of select="p" /></label>
				</div>
				<p>
					<span><xsl:value-of select="a/@href"/></span>
					<span>&#160;&#160;&#160;&#160;<xsl:value-of select="span" /></span>
				</p>
			</div>
			<div class="syblog_search_topic_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	</div>
</xsl:template>
<xsl:template name="pager">
	<xsl:param name="p"/>
	<xsl:if test="$p>1">
		<xsl:if test="($page)>1">
			<a target="iframe_xml_http_request" href="{$url}{number($page)-1}">上一页</a>
		</xsl:if>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:choose>
					<xsl:when test="$p>10 and $page>5">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:value-of select="number($page)-5"/>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="number($p)-10"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:choose>
					<xsl:when test="$p>10">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:choose>
									<xsl:when test="$page>5">
										<xsl:value-of select="number($page)+5"/>
									</xsl:when>
									<xsl:otherwise>10</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:if test="$p>number($page)">
			<a target="iframe_xml_http_request" href="{$url}{number($page)+1}">下一页</a>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="loop">
	<xsl:param name="min"/>
	<xsl:param name="max"/>
	<xsl:if test="$max>=$min">
		<xsl:choose>
			<xsl:when test="number($min)=number($page)">
				<span>
					<xsl:value-of select="$min"/>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<a target="iframe_xml_http_request" href="{$url}{$min}">[<xsl:value-of select="$min" />]</a>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:value-of select="number($min)+1"/>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:value-of select="$max"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>