<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="host"><xsl:value-of select="document('../../host.xml')//conf/host"/></xsl:variable>
<xsl:variable name="url"><xsl:value-of select="$host"/><xsl:value-of select="number(html/@d)"/>/<xsl:value-of select="number(html/@s)"/></xsl:variable>
<xsl:variable name="page"><xsl:choose><xsl:when test="number(html/@p)>0"><xsl:value-of select="html/@p"/></xsl:when><xsl:otherwise>1</xsl:otherwise></xsl:choose></xsl:variable>
<xsl:variable name="size"><xsl:value-of select="html/@sz"/></xsl:variable>
<xsl:variable name="userdir">/<xsl:value-of select="html/@u"/>/</xsl:variable>
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	  	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	  	<script language="javascript">
	  		if(typeof(parent.showResult)!="function") {
	  			location.replace("<xsl:value-of select="$host" />#" + location.pathname);
	  		}
	  		window.onload = function() {
				parent.showResult(document.getElementById("output").innerHTML.replace(/\[img\]([^\[]*)\[\/img\]/img,String.fromCharCode(60) + 'img src="$1" /' + String.fromCharCode(62)),location.href);
	  		}
	  	</script>
	</head>
	<body>
		<div id="output"><xsl:apply-templates select="body/p"/></div>
	</body>
</html>
</xsl:template>
<xsl:template match="body/p[1]">
	<xsl:choose>
		<xsl:when test="count(p)>0">
			<xsl:for-each select="p">
				<div class="sycode_sort_list_item">
					<div class="sycode_sort_list_item_right_bar">
						<div class="sycode_sort_list_item_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
						<div class="sycode_sort_list_item_content">
							<div class="sycode_sort_list_item_title" onclick="toggleDl(this)">
								<div>
									<xsl:if test="@top='1'">
										<span>置顶</span>
									</xsl:if>
									<a target="iframe_xml_http_request" href="{a/@href}" title="{a}">
										<xsl:value-of select="a" />
									</a>
								</div>
							</div>
							<div class="sycode_sort_list_item_body">
								<pre>
									<xsl:value-of select="p" />
								</pre>
							</div>
							<div class="sycode_sort_list_item_stat">
								<div class="sycode_sort_list_item_time"><xsl:value-of select="@l" /></div>
								<div class="sycode_sort_list_item_links">
									<a target="iframe_xml_http_request" href="{a/@href}">阅读(<xsl:value-of select="@vc" />)</a>
									<span>|</span>
									<a target="iframe_xml_http_request" href="{a/@href}#comment">评论(<xsl:value-of select="@c" />)</a>
									<span>|</span>
									<a target="iframe_xml_http_request" href="{a/@href}#trackback">引用(<xsl:value-of select="@t" />)</a>
								</div>
							</div>
						</div>
						<div class="sycode_sort_list_item_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
					</div>
				</div>
			</xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
			<p class="syblog_empty" align="center">没有文章！</p>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
<xsl:template match="body/p[2]">
	<xsl:if test="number(.)>number($size)">
		<div class="syblog_pager">
			<div class="syblog_pager_right_bar">
				<div class="syblog_pager_header_bar"><span class="left"></span><span class="right"></span></div>
				<div class="syblog_pager_content">
					<xsl:call-template name="pager">
						<xsl:with-param name="p">
							<xsl:value-of select="ceiling(number(.) div number($size))"/>
						</xsl:with-param>
					</xsl:call-template>
				</div>
				<div class="syblog_pager_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
			</div>
		</div>
	</xsl:if>
</xsl:template>
<xsl:template name="pager">
	<xsl:param name="p"/>
	<xsl:if test="$p>1">
		<xsl:if test="($page)>1">
			<a target="iframe_xml_http_request" href="{$url}/{$size}/{number($page)-1}.aspx">上一页</a>
		</xsl:if>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:choose>
					<xsl:when test="$p>10 and $page>5">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:value-of select="number($page)-5"/>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="number($p)-10"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>1</xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:choose>
					<xsl:when test="$p>10">
						<xsl:choose>
							<xsl:when test="$p>$page+5">
								<xsl:choose>
									<xsl:when test="$page>5">
										<xsl:value-of select="number($page)+5"/>
									</xsl:when>
									<xsl:otherwise>10</xsl:otherwise>
								</xsl:choose>
							</xsl:when>
							<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise><xsl:value-of select="$p"/></xsl:otherwise>
				</xsl:choose>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:if test="$p>number($page)">
			<a target="iframe_xml_http_request" href="{$url}/{$size}/{number($page)+1}.aspx">下一页</a>
		</xsl:if>
	</xsl:if>
</xsl:template>
<xsl:template name="loop">
	<xsl:param name="min"/>
	<xsl:param name="max"/>
	<xsl:if test="$max>=$min">
		<xsl:choose>
			<xsl:when test="number($min)=number($page)">
				<span>
					<xsl:value-of select="$min"/>
				</span>
			</xsl:when>
			<xsl:otherwise>
				<a target="iframe_xml_http_request" href="{$url}/{$size}/{$min}.aspx">[<xsl:value-of select="$min" />]</a>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:call-template name="loop">
			<xsl:with-param name="min">
				<xsl:value-of select="number($min)+1"/>
			</xsl:with-param>
			<xsl:with-param name="max">
				<xsl:value-of select="$max"/>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:if>
</xsl:template>
</xsl:stylesheet>