<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:variable name="host"><xsl:value-of select="document('../../host.xml')//conf/host"/></xsl:variable>
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
	  	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	  	<script language="javascript">
	  		if(typeof(parent.showResult)!="function") {
	  			location.replace("<xsl:value-of select="$host" />#" + location.pathname);
	  		}
	  		window.onload = function() {
				parent.showResult(document.getElementById("output").innerHTML.replace(/\[img\]([^\[]*)\[\/img\]/img,String.fromCharCode(60) + 'img src="$1" /' + String.fromCharCode(62)),location.href);
	  		}
	  	</script>
	</head>
	<body>
		<div id="output"><xsl:apply-templates select="body"/></div>
	</body>
</html>
</xsl:template>
<xsl:template match="body">
	<xsl:choose>
		<xsl:when test="count(p)>0">
			<xsl:for-each select="p">
				<div class="sycode_sort_list_item">
					<div class="sycode_sort_list_item_right_bar">
						<div class="sycode_sort_list_item_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
						<div class="sycode_sort_list_item_content">
							<div class="sycode_sort_list_item_title" onclick="toggleDl(this)">
								<div>
									<a target="iframe_xml_http_request" href="{a[1]/@href}" title="{a[1]}">
										<xsl:value-of select="a[1]" />
									</a>
								</div>
							</div>
							<div class="sycode_sort_list_item_body">
								<pre>
									<xsl:value-of select="p" />
								</pre>
							</div>
							<div class="sycode_sort_list_item_stat">
								<div class="sycode_sort_list_item_time"><xsl:value-of select="@l" /></div>
								<div class="sycode_sort_list_item_links">
									<a target="iframe_xml_http_request" href="{a[1]/@href}">阅读(<xsl:value-of select="@vc" />)</a>
									<span>|</span>
									<a target="iframe_xml_http_request" href="{a[1]/@href}#comment">评论(<xsl:value-of select="@c" />)</a>
									<span>|</span>
									<a target="iframe_xml_http_request" href="{a[1]/@href}#trackback">引用(<xsl:value-of select="@t" />)</a>
								</div>
							</div>
						</div>
						<div class="sycode_sort_list_item_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
					</div>
				</div>
			</xsl:for-each>
		</xsl:when>
		<xsl:otherwise>
			<p class="syblog_empty" align="center">此时间段没有文章存档,或者已被删除！</p>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>