<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	  	<script language="javascript">
	  		if(typeof(parent.showResult)!="function") {
	  			location.replace("./#tags.aspx");
	  		}
	  		window.onload = function() {
				var links = document.getElementsByTagName("a");
				var colors = ["000","f00","0f0","00f","900","090","009","600","060","006"];
				var css = ["margin:6px 12px;color:#","",";font-size:","","px;font-weight:",""];
				for(var i = 0;i != links.length;i++) {
					with(links[i]) {
						css[1] = colors[Math.floor(Math.random() * 8.999)];
						css[3] = Math.floor(Math.random() * 3.999) * 2 + 12;
						css[5] = Math.floor(Math.random() * 8.999 + 1) * 100;
						setAttribute("csstext", css.join(''));
					}
				}
				parent.showResult(document.getElementById("output").innerHTML.replace(/csstext=/gm,"style="),location.href);
	  		}
	  	</script>
	</head>
	<body><div id="output">
		<xsl:choose>
			<xsl:when test="count(body/a)>0">
				<div class="sycode_tags_list">
					<div class="sycode_tags_list_right_bar">
						<div class="sycode_tags_list_header_bar header_bar"><span class="left"></span><span class="right"></span></div>
						<div class="sycode_tags_list_content">
							<xsl:for-each select="body/a">
								<a target="iframe_xml_http_request" href="{@href}" alt="{.}({@id})"><xsl:value-of select="." />(<xsl:value-of select="@id" />)</a>
							</xsl:for-each>
						</div>
						<div class="sycode_tags_list_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
					</div>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<p class="syblog_empty" align="center">没有使用过的标签</p>
			</xsl:otherwise>
		</xsl:choose>
	</div></body>
</html>
</xsl:template>
</xsl:stylesheet>