<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="comment.xsl"/>
<xsl:variable name="id"><xsl:value-of select="html/head/meta[@name='author']/@id"/></xsl:variable>
<xsl:variable name="url">tag.aspx?id=</xsl:variable>
<xsl:variable name="host"><xsl:value-of select="document('../../host.xml')//conf/host"/></xsl:variable>
<xsl:variable name="comment"><xsl:value-of select="document(concat('../../topicstat.aspx?id=', $id))//dataset/table/row/@comment" /></xsl:variable>
<xsl:variable name="trackback"><xsl:value-of select="document(concat('../../topicstat.aspx?id=', $id))//dataset/table/row/@trackback" /></xsl:variable>
<xsl:variable name="p"><xsl:value-of select="ceiling(number($comment) div 30)" /></xsl:variable>
<xsl:variable name="dir">../../topic/<xsl:value-of select="$id" />/</xsl:variable>
<xsl:variable name="cd"><xsl:value-of select="concat($dir,concat(string($p),'.xml'))" /></xsl:variable>
<xsl:variable name="td"><xsl:value-of select="concat($dir,'trackback.xml')" /></xsl:variable>
<xsl:variable name="cp"><xsl:if test="number($comment)>0"><xsl:value-of select="document(string($cd))//comments/comment[1]/@id" /></xsl:if></xsl:variable>
<xsl:variable name="tp"><xsl:if test="number($trackback)>0"><xsl:value-of select="document(string($td))//html/head/title" /></xsl:if></xsl:variable>
<xsl:output method="html" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd" doctype-public="-//W3C//DTD XHTML 1.1//EN" indent="yes" encoding="utf-8"/>
<xsl:template match="/html">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<title><xsl:value-of select="head/title" /></title>
	  	<script language="javascript">
	  		if(typeof(parent.showResult)!="function") {
	  			location.replace("../../#topic/<xsl:value-of select="$id" />/");
	  		}
	  		window.onload = function() {
	  			var output =  document.getElementById("output");
				var html = output.innerHTML;
				
				if(location.hash.toLowerCase() == "#trackback") {
					html = html.replace('display="comment"', 'style="display:none"');
					html = html.replace('curren="trackback"', 'class="curren"');
				}
				else {
					html = html.replace('display="trackback"', 'style="display:none"');
					html = html.replace('curren="comment"', 'class="curren"');
				}
				html = html.replace(/_src="/gmi, 'src="');
				var b = document.getElementById("syblog_transformiix");
				html = html.replace(b.parentNode.innerHTML, b.value);
				parent.showResult(html,location.href,parent.hightLight);
	  		}
	  	</script>
	</head>
	<body>
		<div id="output">
			<xsl:call-template name="output"/>
		</div>
	</body>
</html>
</xsl:template>
<xsl:template name="output">
	<div class="sycode_topic">
		<div class="sycode_topic_right_bar">
			<div class="sycode_topic_header_bar"><span class="left"></span><span class="right"></span></div>
			<div class="sycode_topic_content">
				<div id="sycode_topic_title">
					<xsl:value-of select="head/title" />
				</div>
				<xsl:if test="count(body/a)>0">
					<div class="sycode_topic_tags">
						<span>标签：</span>
						<xsl:for-each select="body/a">
							<a target="iframe_xml_http_request" href="{@href}">
								<xsl:value-of select="." />
							</a>
						</xsl:for-each>
					</div>
				</xsl:if>
				<div id="sycode_topic_body">
					<input id="syblog_transformiix" type="hidden">
						<xsl:attribute name="value">
							<xsl:value-of select="body/p" />
						</xsl:attribute>
					</input>
				</div>
				<xsl:apply-templates select="document(concat('../../topicstat.aspx?id=', $id))//dataset" />
				<div class="sycode_topic_comment_form">
					<div class="sycode_topic_comment_form_right_bar">
						<div class="sycode_topic_comment_form_header_bar"><span class="left"></span><span class="right"></span></div>
						<div class="sycode_topic_comment_form_content">
							<xsl:choose>
								<xsl:when test="@nocomment='1'">
									<p align="center">博主已关闭此日志的评论</p>
								</xsl:when>
								<xsl:otherwise>
									<form id="sycode_topic_comment_form" action="PostComment.aspx" onsubmit="return false">
										<input type="hidden" name="id" value="{$id}"></input>
										<div>
											<span>署　名：</span>
											<input maxlength="16" type="text" class="sign" name="sign"/>
										</div>
										<div>
											<span>主　页：</span>
											<input maxlength="255" size="40" type="text" class="sign" name="site" value="http://"/>
										</div>
										<div>
											<span>验证码：</span>
											<input maxlength="5" min="5" max="5" onclick="if(!this.nextSibling.src)this.nextSibling.src='CRCImage.aspx?mod=comment&amp;' + (new Date()).getTime()" msg="必须输入验证码" type="text" class="crcode" name="crcode" style="ime-mode:disabled"/><img class="crcimg" alt="点击验证码输入框显示验证码" onclick="this.src='CRCImage.aspx?mod=comment&amp;' + (new Date()).getTime()" />
										</div>
										<div>
											<span>评论内容：</span>
											<textarea name="content" min="1" msg="必须输入评论内容" onfocus="if(this.value=='请输入评论内容')this.value=''">请输入评论内容</textarea>
										</div>
										<div>
											<button name="submit" onclick="postComment(this)">发表评论</button>
										</div>
									</form>
								</xsl:otherwise>
							</xsl:choose>
						</div>
						<div class="sycode_topic_comment_form_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
					</div>
				</div>
			</div>
			<div class="sycode_topic_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	</div>
</xsl:template>
<xsl:template match="/dataset">
	<div class="sycode_topic_control">
		<div class="sycode_topic_toptip">
			<div>&#160;</div>
			<div for="sycode_topic_trackback" curren="trackback">
				<a href="#" unselectable="on" onclick="showTopicItem(this.parentNode,'nextSibling');return false;">引用(<xsl:value-of select="table/row/@trackback" />)</a>
			</div>
			<div for="sycode_topic_comment" curren="comment">
				<a href="#" unselectable="on" onclick="showTopicItem(this.parentNode,'previousSibling');return false;">评论(<xsl:value-of select="table/row/@comment" />)</a>
			</div>
			<div>
				<xsl:value-of select="table/row/@viewcount" /><xsl:text>次阅读</xsl:text>
			</div>
			<div>
				<xsl:value-of select="table/row/@lastupdate" />
			</div>
			<div class="static">
				<a href="#" onclick="history.back();return false;">返回</a>
			</div>
		</div>
		<xsl:if test="count(table/row) > 1">
			<div class="sycode_topic_navigation">
				<xsl:if test="count(table[2]/row) > 0">
					<div>
						<a target="iframe_xml_http_request" href="topic/{table[2]/row/@id}/">上一篇:<xsl:value-of select="table[2]/row/@title" /></a>
					</div>
				</xsl:if>
				<xsl:if test="count(table[3]/row) > 0">
					<div>
						<a target="iframe_xml_http_request" href="topic/{table[3]/row/@id}/">下一篇:<xsl:value-of select="table[3]/row/@title" /></a>
					</div>
				</xsl:if>
			</div>
		</xsl:if>
	</div>
	<div id="sycode_topic_trackback" display="trackback">
		<div class="sycode_topic_trackback_url">
			<p class="sycode_topic_comment_title">Trackback地址：</p>
			<span><xsl:value-of select="$host"/>trackback/<xsl:value-of select="$id" />.aspx</span>
		</div>
		<xsl:if test="number($trackback)>0">
			<xsl:apply-templates select="document($td)//html/body/p"/>
		</xsl:if>
	</div>
	<div id="sycode_topic_comment" display="comment">
		<p class="sycode_topic_comment_title">评论:</p>
		<xsl:if test="number($comment)>0">
			<xsl:call-template name="comment" />
		</xsl:if>
	</div>
</xsl:template>
<xsl:template match="/html/body/p">
	<div class="syblog_topic_trackback">
		<div class="syblog_topic_trackback_right_bar">
			<div class="syblog_topic_trackback_header_bar"><span class="left"></span><span class="right"></span></div>
			<div class="syblog_topic_trackback_content">
				<fieldset>
					<legend>作者：<span><xsl:value-of select="a/@title" /></span>发表时间：<span><xsl:value-of select="@time" /></span></legend>
					<a target="_blank" href="{a/@href}">
						<xsl:value-of select="a" />
					</a>
					<pre>	
						<xsl:value-of select="pre" />
					</pre>
				</fieldset>
			</div>
			<div class="syblog_topic_trackback_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	</div>
</xsl:template>
<xsl:template name="comment">
	<div>
		<xsl:apply-templates select="document($cd)//html/body/a" />
	</div>
	<xsl:if test="number($p)>1">
		<div class="syblog_pager">
			<div class="syblog_pager_right_bar">
				<div class="syblog_pager_header_bar"><span class="left"></span><span class="right"></span></div>
				<div class="syblog_pager_content">
					<div class="syblog_topic_comment_pager">
						<a href="#" onclick="commentPage(this,'{$id}',{number($p)-1},{$p});return false;">上一页</a>
						<xsl:call-template name="pager">
							<xsl:with-param name="min">
								<xsl:value-of select="number($p)-10"/>
							</xsl:with-param>
							<xsl:with-param name="max">
								<xsl:value-of select="$p"/>
							</xsl:with-param>
						</xsl:call-template>
					</div>
				</div>
				<div class="syblog_pager_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
			</div>
		</div>
	</xsl:if>
</xsl:template>
<xsl:template name="pager">
	<xsl:param name="min"/>
	<xsl:param name="max"/>
	<xsl:choose>
		<xsl:when test="number($min)=number($max)">
			<span><xsl:value-of select="$min" /></span>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="number($min)>0">
				<a href="#" onclick="commentPage(this,'{$id}',{$min},{$max});return false;">[<xsl:value-of select="$min" />]</a>
			</xsl:if>
			<xsl:call-template name="pager">
				<xsl:with-param name="min">
					<xsl:value-of select="number($min)+1"/>
				</xsl:with-param>
				<xsl:with-param name="max">
					<xsl:value-of select="$max"/>
				</xsl:with-param>
			</xsl:call-template>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>