<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:import href="../../common/module.xsl"/>
<xsl:template name="body">
	<!--外层框架开始,左边边框容器-->
	<div class="syblog_outer_frame">
		<!--外层框架的右边边框 -->
		<div class="syblog_outer_right_bar">
			<!--外层框架的顶部边框-->
			<div class="syblog_outer_header_bar"><span class="left"></span><span class="right"></span></div>
			<!--BLOG标题,左边边框容器-->
			<div class="syblog_top_frame">
				<!--BLOG标题的右边边框-->
				<div class="syblog_top_right_bar">
					<!--BLOG标题的顶部边框-->
					<div class="syblog_top_header_bar"><span class="left"></span><span class="right"></span></div>
					<div class="syblog_top_content">
						<xsl:call-template name="title" />
					</div>
					<!--BLOG标题的底部边框-->
					<div class="syblog_top_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
				</div>
			</div>
			<!--内层框架,左边边框容器-->
			<div class="syblog_middle_frame">
				<!--内层框架的右边边框-->
				<div class="syblog_middle_right_bar">
					<!--内层框架的顶部边框-->
					<div class="syblog_middle_header_bar"><span class="left"></span><span class="right"></span></div>
					<!--左侧栏目,左边边框容器-->
					<div class="syblog_middle_left">
						<!--左侧栏目的右边边框-->
						<div class="syblog_middle_left_right_bar">
							<!--左侧栏目的顶部边框-->
							<div class="syblog_middle_left_header_bar"><span class="left"></span><span class="right"></span></div>
							<!--左侧栏目的内容-->
							<div class="syblog_middle_left_content">
								<xsl:call-template name="channel" />
								<!--
									栏目加载
										左侧栏目
										<xsl:apply-templates select="body/a[@display='1' and position='0']"/>
										中间栏目
										<xsl:apply-templates select="body/a[@display='1' and position='1']"/>
										右侧栏目
										<xsl:apply-templates select="body/a[@display='1' and position='2']"/>
										不区分位置
										<xsl:apply-templates select="body/a[@display='1']"/>
								-->
								<xsl:apply-templates select="body/a[@display='1']"/>
								<xsl:call-template name="rss" />
							</div>
							<!--左侧栏目的底部边框-->
							<div class="syblog_middle_left_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
						</div>
					</div>
					<!--活动内容框架,左边边框容器-->
					<div class="syblog_middle_center">
						<!--活动内容的右边边框-->
						<div class="syblog_middle_center_right_bar">
							<!--活动内容的顶部边框-->
							<div class="syblog_middle_center_header_bar"><span class="left"></span><span class="right"></span></div>
							<div class="syblog_menu_search">
								<!--搜索框-->
								<xsl:call-template name="search" />
								<!--快捷菜单-->
								<xsl:call-template name="menu" />
							</div>
							<!--活动内容-->
							<div class="syblog_middle_center_content">
								<!--活动内容的顶部图片容器-->
								<div class="syblog_banner_frame"></div>
								<!--Blog主体内容容器-->
								<xsl:call-template name="main" />
							<!--活动内容结束-->
							</div>				
							<!--活动内容的底部边框-->
							<div class="syblog_middle_center_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
						</div>
					<!--活动内容框架结束-->
					</div>
					<!--内层框架的底部边框-->
					<div class="syblog_middle_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
				</div>
			<!--内层框架结束-->
			</div>
			<!--低部链接和版权信息-->
			<xsl:call-template name="footer" />
			<!--外层框架的底部边框-->
			<div class="syblog_outer_footer_bar footer_bar"><span class="left"></span><span class="right"></span></div>
		</div>
	<!--外层框架结束-->
	</div>
</xsl:template>
</xsl:stylesheet>