﻿using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Session["Admin"] == null)
        {
            this.PopupWin1.Message = "欢迎游客的访问,你可以在线发帖！你的IP是："+Request.UserHostAddress;
        }
        else
        {
            this.PopupWin1.Message = "欢迎管理员" + Session["Admin"] + "登陆,你可以管理帖子! 你的IP是："+Request.UserHostAddress;
        }
        if (!Page.IsPostBack)
        {
            this.DandData();     //绑定数据
        }
    }

    //为下拉列表添加选择项
    private void getListItem()
    {
        for (int i = 0; i < Convert.ToInt32(DB.Num); i++)
        {
            this.DropDownList1.Items.Add(Convert.ToString(Convert.ToInt32(i) + 1));
        }
    }

    private void DandData()
    {
        this.DropDownList1.Items.Clear();
        this.getListItem();   //向下拉列表中添加分页数

        int currPage = Convert.ToInt32(this.Label1.Text);

        SqlConnection conn = DB.getConnection();
        SqlDataAdapter da = new SqlDataAdapter();
        da.SelectCommand = new SqlCommand("select * from guestInfo order by ID desc", conn);
        DataSet ds = new DataSet();
        da.Fill(ds, "guestInfo");
        
        PagedDataSource pds = new PagedDataSource(); //对用于分页的类的引用
        pds.DataSource = ds.Tables["guestInfo"].DefaultView;//设置数据源(DataSet类型)
        pds.AllowPaging = true;

        pds.PageSize = 3;   //指定每页显示几条记录
        pds.CurrentPageIndex = currPage - 1;    //获取当前页索引后转到索引页
        
        if (currPage == 1)
        {
            this.Button1.Enabled = false;
            this.Button2.Enabled = false;
        }
        else
        {
            this.Button1.Enabled = true;
            this.Button2.Enabled = true;
        }
        
        if (currPage == pds.PageCount)
        {
            this.Button4.Enabled = false;
            this.Button3.Enabled = false;
        }
        else
        {
            this.Button4.Enabled = true;
            this.Button3.Enabled = true;
        }

        DB.Num = Convert.ToString(pds.PageCount);

        conn.Open();
        SqlCommand cmd = new SqlCommand("select count(*) from guestInfo", conn);
        this.Label2.Text = "留言总记录数" + Convert.ToString((int)cmd.ExecuteScalar()) + "条";
        conn.Close();

        this.DataList1.DataSource = pds;
        this.DataList1.DataBind();
    }

    //单击上一页按钮事件
    protected void Button2_Click(object sender, EventArgs e)
    {
        this.Label1.Text = Convert.ToString(Convert.ToInt32(this.Label1.Text) - 1);
        this.DandData();
        this.DropDownList1.Text = this.Label1.Text;
    }

    //单击下一页按钮事件
    protected void Button3_Click(object sender, EventArgs e)
    {
        this.Label1.Text = Convert.ToString(Convert.ToInt32(this.Label1.Text) + 1);
        this.DandData();
        this.DropDownList1.Text = this.Label1.Text;
    }

    //单击首页按钮事件
    protected void Button1_Click(object sender, EventArgs e)
    {
        this.Label1.Text = "1";
        this.DandData();
        this.DropDownList1.Text = this.Label1.Text;
    }

    //单击尾页按钮事件
    protected void Button4_Click(object sender, EventArgs e)
    {
        this.Label1.Text = DB.Num;
        this.DandData();
        this.DropDownList1.Text = this.Label1.Text;
    }
    
    //下拉列表选中后转到指定的页
    protected void DropDownList1_SelectedIndexChanged(object sender, EventArgs e)
    {
        this.Label1.Text = this.DropDownList1.SelectedValue.ToString();
        this.DandData();
    }

    protected void DataList1_SelectedIndexChanged(object sender, EventArgs e)
    {

    }

    protected void DataList1_ItemCommand(object source, DataListCommandEventArgs e)
    {
        //删除业务处理
        if (e.CommandName == "del")
        {
            if (Session["Admin"] == null)
            {
                Response.Redirect("ShowInfo.aspx?info="+Server.HtmlEncode("对不起！只有管理员才有此权限！如果你是管理员请登陆！！")+"");
            }
            else
            {
                int ID = Convert.ToInt32(e.CommandArgument);
                //Response.Write("<script>alert('"+ID+"')</script>");
                SqlConnection conn = DB.getConnection();
                SqlCommand cmd = new SqlCommand("delete from guestInfo where ID = " + ID + "", conn);
                conn.Open();
                int count = cmd.ExecuteNonQuery();
                conn.Close();
                if (count > 0)
                {
                    Response.Write("<script>alert('删除成功！！')</script>");
                    this.DandData();
                }
            }
        }

         //回帖业务处理
        if (e.CommandName == "Reply")
        {
            int ID = Convert.ToInt32(e.CommandArgument);
            if (Session["Admin"] == null)
            {
                Response.Redirect("ShowInfo.aspx?info=" + Server.HtmlEncode("对不起！只有管理员才有此权限！如果你是管理员请登陆！！") + "");
            }
            else
            {
                Response.Write("<script>alert('" + ID + "')</script>");
                Response.Redirect("Reply.aspx?ID=" + Server.HtmlEncode(ID.ToString()) + "");
            }
        }
    }

    protected void DataList1_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        //确认是否删除，友好性
        LinkButton lbtdel = e.Item.FindControl("lbtdel") as LinkButton;
        if (lbtdel != null)
        {
            lbtdel.Attributes.Add("onclick", "return confirm('你确认删除该条记录！')");
        }
    }
}
