﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

using LeaveMessageMVC.MVC.BusinessLogicLayer.ParameterInformation;
using LeaveMessageMVC.MVC.DataBaseControlLayer;
using LeaveMessageMVC.MVC.BusinessLogicLayer;
using LeaveMessageMVC.MVC.BusinessLogicLayer.SomeFunctions;

//该源码下载自www.51aspx.com(５１ａｓｐｘ．ｃｏｍ)

public partial class AdministratorControl : System.Web.UI.UserControl
{
    LeaveMessageMVC.MVC.BusinessLogicLayer.ParameterInformation.LeaveMessagePara LMP = new LeaveMessagePara();

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            LMBind(0);
            DeleteSNButton.Attributes.Add("onclick", "return confirm(\"确定要删除所选留言吗？\")");
            //如果是false，不会激活服务器端的事件
        }
    }

    #region
    protected void LMBind(int pn)
    {
        DataTable dt = null;

        if (!DBControl.AccessConnection)
        {
            dt = DataReaderToDT(LMManage.GetLeaveMessage(0));
            dt.AcceptChanges();
            LMListDG.DataSource = dt;
        }
        else
        {
            dt = LMManage.aGetLeaveMessage(0);
            dt.AcceptChanges();
            LMListDG.DataSource = dt;
        }
        LMListDG.DataBind();
    }

    /// <summary>
    /// DataReader转为DataTable
    /// </summary>
    /// <param name="dr"></param>
    /// <returns></returns>
    protected DataTable DataReaderToDT(IDataReader dr)
    {
        DataTable dt = new DataTable();

        for (int i = 0; i < dr.FieldCount; i++)
        {
            dt.Columns.Add(dr.GetName(i), dr.GetFieldType(i));
        }

        dt.BeginLoadData();
        object[] values = new object[dr.FieldCount - 1];
        while (dr.Read())
        {
            dr.GetValues(values);
            dt.LoadDataRow(values, true);
        }
        dr.Close();
        dt.EndLoadData();

        return dt;
    }
    #endregion

    protected string ShortString(string txt, int wordSize, string id)
    {
        //限制显示的字符数，避免篇幅太大
        if (txt == "" && id == "")
            txt = "无标题";
        else
        {
            txt = txt.Replace("<", "&lt;");
            txt = txt.Replace(">", "&gt;");
        }

        if (id == "")
        {
            if (txt.Length > wordSize && wordSize != 0)
                return txt.Substring(0, wordSize - 3) + "...";
            else
                return txt;
        }
        else
        {
            if (txt.Length > wordSize && wordSize != 0)
                return "<a href=\"ShowDetail.aspx?d_ID=" + id + "\" target=\"_blank\">" + txt.Substring(0, wordSize - 3) + "...</a>";
            else
                return "<a href=\"ShowDetail.aspx?d_ID=" + id + "\" target=\"_blank\">" + txt + "</a>";
        }

    }

    ////调用这个函数也可以实现全选CheckBox，但会出现闪屏现象，因为是传会服务器
    //protected void WillBeDeleted_Checked()   
    //{
    //    foreach (RepeaterItem item in LMListRepeater.Items)
    //    {
    //        CheckBox cb = (CheckBox)item.FindControl("WillBeDeleted");    //"WillBeDeleted"为CheckBox控件ID
    //        cb.Checked = true;
    //    }       
    //}

    protected void DeleteSNButton_Click(object sender, EventArgs e)
    {
        string[] DID = new string[50];
        int SelectedLines = 0;

        foreach (DataGridItem item in LMListDG.Items)
        {
            CheckBox cb = (CheckBox)item.FindControl("WillBeDeleted");    //"WillBeDeleted"为CheckBox控件ID
            if (cb.Checked == true)
            {
                DID[SelectedLines++] = LMListDG.DataKeys[item.ItemIndex].ToString();
            }
        }

        if (LMManage.DeleteLeaveMessage(DID))
        {
            //每次从数据库删除留言成功，就使保存 表行数 的全局变量 -n（n为被删除留言行数）
            Application.Lock();
            Application["TableCount"] = (int)Application["TableCount"] - SelectedLines;
            Application.UnLock();

            LMBind(0);
        }
    }

    protected void LMListDG_PageIndexChanged(object source, DataGridPageChangedEventArgs e)
    {
        LMListDG.CurrentPageIndex = e.NewPageIndex;
        LMBind(0);
    }

    protected void LMListDG_EditCommand(object source, DataGridCommandEventArgs e)
    {
        LMListDG.EditItemIndex = e.Item.ItemIndex;
        LMBind(0);
    }
    
    protected void LMListDG_UpdateCommand(object source, DataGridCommandEventArgs e)
    {
        LMP.ID = LMListDG.DataKeys[e.Item.ItemIndex].ToString();
        LMP.Title = ((TextBox)e.Item.FindControl("TB_Title")).Text;
        LMP.Contents = ((TextBox)e.Item.FindControl("TB_Contents")).Text;
        LMP.WriteBack = ((TextBox)e.Item.FindControl("TB_WriteBack")).Text;

        if (LMManage.UpdateLeaveMessageAll(LMP))
        {
            Response.Write("<Script Language=JavaScript>alert(\"更新成功！\");</script>");
        }
        else Response.Redirect("ShowErrorMsg.aspx?name=Administrator");

        LMListDG.EditItemIndex = -1;

        LMBind(0);
    }

    protected void LMListDG_CancelCommand(object source, DataGridCommandEventArgs e)
    {
        LMListDG.EditItemIndex = -1;
        LMBind(0);
    }
}
