﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Windows.Forms;

using LeaveMessageMVC.MVC.BusinessLogicLayer.ParameterInformation;
using LeaveMessageMVC.MVC.DataBaseControlLayer;
using LeaveMessageMVC.MVC.BusinessLogicLayer;
using LeaveMessageMVC.MVC.BusinessLogicLayer.SomeFunctions;

//该源码下载自www.51aspx.com(５１ａｓｐｘ．ｃｏｍ)
//edit by 51aspx
    public partial class LMListForPublic : System.Web.UI.Page
    {
      LeaveMessageMVC.MVC.BusinessLogicLayer.ParameterInformation.LeaveMessagePara LMP = new LeaveMessagePara();
        int f=0;
        const int cPageSize = 15;                   //设置分页控件每页显示的行数

        protected void Page_Load(object sender, EventArgs e)
        {
            if(Application["TableCount"]!=null)

            f = (int)Application["TableCount"];

            if (!Page.IsPostBack)
            {
                //禁止浏览器的缓存，防止用户发布信息后点“后退”返回到原来未发布的状态（虽然实际数据已写入DB）
                Response.Cache.SetNoStore();
                Response.Cache.SetNoServerCaching();

                Response.Write("<script type=\"text/javascript\">");
                Response.Write("function CtrlEnter(button){");
                Response.Write("if(event.ctrlKey && event.keyCode==13)document.all[button].click();}");
                //Response.Write("var floor=" + Application["TableCount"] + ";");
                //Response.Write("function NextFloor(){floor--;}");
                Response.Write("</script>");
                TBcontents.Attributes.Add("onkeydown", "CtrlEnter('Submit');");

                if (Session["BUser"] != null)
                {
                    TBuser.Text = Session["BUser"].ToString();
                    //Session["BUser"] = null;
                }
                if (Session["QQorMSN"] != null)
                {
                    TBQQMSN.Text = Session["QQorMSN"].ToString();
                    //Session["QQorMSN"] = null;
                }

                if (Session["PageNumber"] != null)
                {
                    LMBind((int)Session["PageNumber"]);
                    Session["PageNumber"] = null;
                }
                else
                    LMBind(0);
            }
        }

        protected void Submit_Click(object sender, EventArgs e)
        {
            if (TBuser.Text == "" || TBQQMSN.Text == "" || TBcontents.Text == "")
            {
                Response.Write("<Script Language=JavaScript>alert(\"提示：用户名、QQ/MSN、留言信息3项必填。\")</Script>");
                Response.Write("<Script Language=JavaScript>this.location.href=\"#IwantToSay\"</script>");

                Response.Write("<script>setTimeout(\"document.all.TBuser.focus();\",500);</script>");
                //上行代码也可写成两段
                //Response.Write("<script>setTimeout(\"Focus()\",1000);</script>");
                //Response.Write("<script>function Focus(){document.all.TBuser.focus();}</script>");

                //TBuser.Focus();   //用这个在调试时总是提示内存不可读
            }
            else
            {
                LMP.ID = AutoCreateID.NewID();
                LMP.User = FormatString.FormatStr(TBuser.Text);
                LMP.QQMSN = FormatString.FormatStr(TBQQMSN.Text);
                LMP.Title = FormatString.FormatStr(TBtitle.Text);
                LMP.Contents = FormatString.FormatStr(TBcontents.Text);
                LMP.WriteBack = "";
                LMP.SubmitTime = DateTime.Now;

                if (LMManage.AddNewLeaveMessage(LMP))
                {
                    //每次向数据库写入一条留言成功，就使保存 表行数 的全局变量 +1
                    Application.Lock();
                    Application["TableCount"] = (int)Application["TableCount"] + 1;
                    Application.UnLock();

                    TBtitle.Text = "";
                    TBcontents.Text = "";
                    LMBind(0);

                    //采用网页重定向的方法，防止用户提交后刷新页面又提示再一次提交
                    //（同时注意保留用户已填写的用户名和联系方式）
                    Session["BUser"] = LMP.User;
                    Session["QQorMSN"] = LMP.QQMSN;
                    Response.Redirect("LMListForPublic.aspx");
                }
                else Response.Redirect("ShowErrorMsg.aspx?name=" + LMP.User);
            }
        }

        #region Bind
        protected void LMBind(int pn)
        {
            PagedDataSource pds = new PagedDataSource();
            pds.AllowPaging = true;
            pds.PageSize = cPageSize;                          //每页显示的行数
            pds.CurrentPageIndex = pn;

            PageNumber.Text = Convert.ToString(pn + 1);

            if (PageNumber.Text == "1") Prev.Enabled = false;
            else Prev.Enabled = true;

            //考虑总行数与页数关系
            if (Convert.ToInt32(PageNumber.Text) > Convert.ToInt32(Application["TableCount"]) / cPageSize) Next.Enabled = false;
            else Next.Enabled = true;

            if (!DBControl.AccessConnection)
            {
                pds.DataSource = (DataReaderToDT(LMManage.GetLeaveMessage(0))).DefaultView;
                LMGridView.DataSource = pds;
            }
            else
            {
                pds.DataSource = LMManage.aGetLeaveMessage(0).DefaultView;
                LMGridView.DataSource = pds;
            }
            LMGridView.DataBind();
        }

        /// <summary>
        /// DataReader转为DataTable
        /// </summary>
        /// <param name="dr"></param>
        /// <returns></returns>
        protected DataTable DataReaderToDT(IDataReader dr)
        {
            DataTable dt = new DataTable();

            for (int i = 0; i < dr.FieldCount; i++)
            {
                dt.Columns.Add(dr.GetName(i), dr.GetFieldType(i));
            }

            dt.BeginLoadData();
            object[] values = new object[dr.FieldCount - 1];
            while (dr.Read())
            {
                dr.GetValues(values);
                dt.LoadDataRow(values, true);
            }
            dr.Close();
            dt.EndLoadData();

            return dt;
        }
        #endregion

        protected string TitleAndFloor(string title)
        {
            //在标题前加上楼数

            if (title == "")
                title = "无标题";

            return "#" + ((f--) - ((Convert.ToInt32(PageNumber.Text) - 1) * cPageSize)) + "&nbsp;主题：" + title;
        }

        protected void LMGridView_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            //注意：该按钮事件其实没有指明是哪些按钮，因为这需要用到 CommandName 属性，
            //      但该属性已被另作他用，所以点击GridView内任何一个按钮、链接（例如分页链接）都将触发该函数
            //if (TBuser.Text == "")
            //{
            //    Response.Write("<Script Language=JavaScript>alert(\"提示：回复他人留言，你必须在下面的留言框输入您的用户名。\");</script>");
            //    Response.Write("<Script Language=JavaScript>this.location.href=\"#IwantToSay\"</script>");

            //    Response.Write("<script>setTimeout(\"document.all.TBuser.focus();\",1000);</script>");
            //    //上行代码也可写成两段
            //    //Response.Write("<script>setTimeout(\"Focus()\",1000);</script>");
            //    //Response.Write("<script>function Focus(){document.all.TBuser.focus();}</script>");

            //    //TBuser.Focus();   //用这个在调试时总是提示内存不可读
            //}

            #region
            //如果用户在留言页面已经输入了用户名和QQMSN，则将这些信息传到回复页
            if (TBuser.Text != "")
                Session["YourName"] = FormatString.FormatStr(TBuser.Text);
            if (TBQQMSN.Text != "")
                Session["QQMSN"] = FormatString.FormatStr(TBQQMSN.Text);

            //用变量保存“回复”按键所映射的相应留言的ID
            string ButtoMappedID = e.CommandName.ToString();
            //Response.Write(ButtoMappedID);     
            Session["OwnerID"] = ButtoMappedID;
            Response.Redirect("WriteBack.aspx?index=n"); //(1)
            /*//(2)用JavaScript实现自动链接页面
            Response.Write("<script language=JavaScript>window.location=\"Default2.aspx\"</script>");*/
            #endregion
        }
        protected void Next_Click(object sender, EventArgs e)
        {
            PageNumber.Text = Convert.ToString((Convert.ToInt32(PageNumber.Text) + 1));

            //LMBind((Convert.ToInt32(PageNumber.Text) - 1));
            Session["PageNumber"] = (Convert.ToInt32(PageNumber.Text) - 1);
            Response.Redirect("LMListForPublic.aspx");                  //为解决刷新问题
        }
        protected void Prev_Click(object sender, EventArgs e)
        {
            PageNumber.Text = Convert.ToString((Convert.ToInt32(PageNumber.Text) - 1));

            //LMBind((Convert.ToInt32(PageNumber.Text) - 1));
            Session["PageNumber"] = (Convert.ToInt32(PageNumber.Text) - 1);
            Response.Redirect("LMListForPublic.aspx");                  //为解决刷新问题
        }
        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text == "51aspx")
                Response.Redirect("AdminControlPage.aspx");
            TextBox1.Text = "";
        }
    }
