using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Data.OleDb;
using LeaveMessageMVC.MVC.BusinessLogicLayer.ParameterInformation;
using LeaveMessageMVC.MVC.BusinessLogicLayer;
using LeaveMessageMVC.MVC.BusinessLogicLayer.SomeFunctions;

namespace LeaveMessageMVC.MVC.DataBaseControlLayer
{
    /// <summary>
    /// DBControl ժҪ˵
    /// </summary>
    public static class DBControl
    {
        /// <summary>
        /// ݿ ַ
        /// </summary>
        /// ע ConfigurationManager.AppSettings["xxx"] ָġxxxweb.configвڣ
        ///        ConnectionString = null
        static private string ConnectionString = ConfigurationManager.AppSettings["DBCONNECTIONSTRING"];

        /// <summary>
        /// ݿ for SQL Server
        /// </summary>
        static private SqlConnection LMDBConnection;

        /// <summary>
        /// ݿ for Access
        /// </summary>
        static private OleDbConnection DBConnection;

        /// <summary>
        /// жǷΪ Accessݿ 
        /// </summary>
        static private bool AccessCnt = false;

        /// <summary>
        /// Ա 쳣 Ϣַ
        /// </summary>
        static private Exception SomeExceptions = new Exception();

        /// <summary>
        /// ȡ쳣Ϣ
        /// </summary>
        public static Exception DBControlError
        {
            get
            {
                return SomeExceptions;
            }
        }

        /// <summary>
        /// жǷΪAccessӵĶӿ
        /// </summary>
        public static bool AccessConnection
        {
            get
            {
                return AccessCnt;
            }
        }

        /// <summary>
        /// Ӳݿ
        /// </summary>
        /// <returns>Ƿɹ</returns>
        public static bool DBOpen()
        {
            bool yesorno = true;

            string JudgeAccessDB = "Microsoft.Jet.OLEDB.4.0";

            //ַﺬ"Microsoft.Jet.OLEDB.4.0"ΪAccess
            if (ConnectionString.Contains(JudgeAccessDB))
            {
                AccessCnt = true;
                try
                {
                    if (LMDBConnection == null)
                    {
                        DBConnection = new OleDbConnection(ConnectionString);
                    }
                    if (DBConnection.State.Equals(ConnectionState.Closed))
                    {
                        DBConnection.Open();
                    }
                }
                catch (Exception DBOpenEx)
                {
                    SomeExceptions = DBOpenEx;
                    yesorno = false;
                }
            }
            else
            {
                //жΪSQL Server
                try
                {
                    if (LMDBConnection == null)
                    {
                        LMDBConnection = new SqlConnection(ConnectionString);
                    }
                    if (LMDBConnection.State.Equals(ConnectionState.Closed))
                    {
                        LMDBConnection.Open();
                    }
                }
                catch (Exception DBOpenEx)
                {
                    SomeExceptions = DBOpenEx;
                    yesorno = false;
                }
            }

            return yesorno;

        }

        /// <summary>
        /// رݿ
        /// </summary>
        public static void DBClose()
        {
            if (!AccessCnt)
            {
                if (LMDBConnection != null)
                    LMDBConnection.Close();
            }
            else
            {
                if (DBConnection != null)
                    DBConnection.Close();
            }
        }

        /// <summary>
        /// ȡ ݿ  for SQL ServerDataReaderȡݣ
        /// </summary>
        /// <returns>زѯ</returns>
        public static SqlDataReader DBSelect(string ReadCode)
        {
            SqlDataReader dr = null;
            try
            {
                DBOpen();
                SqlCommand cmd = new SqlCommand(ReadCode, LMDBConnection);
                dr = cmd.ExecuteReader(CommandBehavior.CloseConnection);
            }
            catch (Exception DBReaderEx)
            {
                SomeExceptions = DBReaderEx;
                dr = null;
            }
            //finally
            //{
            //    DBClose();
            //}

            return dr;
        }

        /// <summary>
        /// ȡ ݿ  for AccessDataAdapterȡݲ䵽DataSet
        /// </summary>
        /// <returns>زѯ</returns>
        public static DataSet aDBSelect(string ReadCode)
        {
            OleDbDataAdapter oda = new OleDbDataAdapter();
            try
            {
                DBOpen();
                oda.SelectCommand = new OleDbCommand(ReadCode, DBConnection);
            }
            catch (Exception DBReaderEx)
            {
                SomeExceptions = DBReaderEx;
                oda = null;
            }

            DataSet ds = new DataSet();
            oda.Fill(ds);

            return ds;
        }

        /// <summary>
        /// ִв롢¡ɾ
        /// </summary>
        /// <param name="IUDCode">롢޸ġɾ</param>
        /// <returns>ִв//ɾӰ0 ΪûӰ캯ʧܷ -1</returns>
        public static int DBExcuteIUD(string IUDCode)
        {
            int TriggerRows = -1;
            try
            {
                DBOpen();
                if (!AccessCnt)
                {
                    SqlCommand cmd = new SqlCommand(IUDCode, LMDBConnection);
                    TriggerRows = cmd.ExecuteNonQuery();
                }
                else
                {
                    OleDbCommand cmd = new OleDbCommand(IUDCode, DBConnection);
                    TriggerRows = cmd.ExecuteNonQuery();
                }
            }
            catch (Exception DBExcuteEx)
            {
                SomeExceptions = DBExcuteEx;
                TriggerRows = -1;
            }
            finally
            {
                DBClose();
            }

            return TriggerRows;
        }

        /// <summary>
        /// ȡݿ  
        /// </summary>
        /// <returns></returns>
        public static int TableCount()
        {
            int count = 0;
            string SQL_SelectCount = "SELECT COUNT(*) FROM " + LMManage.Tables;
            try
            {
                DBOpen();
                if (!AccessCnt)
                {
                    SqlCommand cmd = new SqlCommand(SQL_SelectCount, LMDBConnection);
                    SqlDataReader rd = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                    while (rd.Read())
                        count = rd.GetSqlInt32(0).Value;    //Ҫıˣ   
                    rd.Close();
                }
                else
                {
                    OleDbCommand cmd = new OleDbCommand(SQL_SelectCount, DBConnection);
                    OleDbDataReader rd = cmd.ExecuteReader(CommandBehavior.CloseConnection);
                    while (rd.Read())
                        count = rd.GetInt32(0);    //Ҫıˣ   
                    rd.Close();
                }
            }
            catch (Exception DBExcuteEx)
            {
                SomeExceptions = DBExcuteEx;
                count = -1;
            }
            finally
            {
                DBClose();
            }

            return count;
        }

        /// <summary>
        /// ȡݿص쳣ϢԱ鿴
        /// </summary>
        /// <param name="ex"></param>
        /// <returns></returns>
        public static string DBExceptionEvent()
        {
            return DBControlError.ToString();
        }
    }
}
//Դwww.51aspx.com()
//edit by -