﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Windows.Forms;

using LeaveMessageMVC.MVC.BusinessLogicLayer.ParameterInformation;
using LeaveMessageMVC.MVC.DataBaseControlLayer;
using LeaveMessageMVC.MVC.BusinessLogicLayer;
using LeaveMessageMVC.MVC.BusinessLogicLayer.SomeFunctions;

public partial class LeaveMessagePage : System.Web.UI.Page
{
    LeaveMessageMVC.MVC.BusinessLogicLayer.ParameterInformation.LeaveMessagePara LMP = new LeaveMessagePara();

    protected void Page_Load(object sender, EventArgs e)
    {
        //禁止浏览器的缓存，防止用户发布信息后点“后退”返回到原来未发布的状态（虽然实际数据已写入DB）
        Response.Cache.SetNoStore();
        Response.Cache.SetNoServerCaching();

        Response.Write("<script type=\"text/javascript\">");
        Response.Write("function CtrlEnter(button){");
        Response.Write("if(event.ctrlKey && event.keyCode==13)document.all[button].click();}");
        Response.Write("var floor=" + Application["TableCount"] + ";");
        Response.Write("function NextFloor(){floor--;}");
        Response.Write("</script>");

        if (!Page.IsPostBack)
        {
            LMBind();
            TBcontents.Attributes.Add("onkeydown", "CtrlEnter('Submit');");

            if (Session["BUser"] != null)
            {
                TBuser.Text = Session["BUser"].ToString();
                //Session["BUser"] = null;
            }
            if (Session["QQorMSN"] != null)
            {
                TBQQMSN.Text = Session["QQorMSN"].ToString();
                //Session["QQorMSN"] = null;
            }
        }
    }

    protected void Submit_Click(object sender, EventArgs e)
    {
        if (TBuser.Text == "" || TBQQMSN.Text == "" || TBcontents.Text == "")
        {
            Response.Write("<Script Language=JavaScript>alert(\"提示：用户名、QQ/MSN、留言信息3项必填。\")</Script>");
            Response.Write("<Script Language=JavaScript>this.location.href=\"#IwantToSay\"</script>");

            Response.Write("<script>setTimeout(\"document.all.TBuser.focus();\",500);</script>");
            //上行代码也可写成两段
            //Response.Write("<script>setTimeout(\"Focus()\",1000);</script>");
            //Response.Write("<script>function Focus(){document.all.TBuser.focus();}</script>");

            //TBuser.Focus();   //用这个在调试时总是提示内存不可读
        }
        else
        {
            LMP.ID = AutoCreateID.NewID();
            LMP.User = FormatString.FormatStr(TBuser.Text);
            LMP.QQMSN = FormatString.FormatStr(TBQQMSN.Text);
            LMP.Title = FormatString.FormatStr(TBtitle.Text);
            LMP.Contents = FormatString.FormatStr(TBcontents.Text);
            LMP.WriteBack = "";
            LMP.SubmitTime = DateTime.Now;

            if (LMManage.AddNewLeaveMessage(LMP))
            {
                //每次向数据库写入一条留言成功，就使保存 表行数 的全局变量 +1
                Application.Lock();
                Application["TableCount"] = (int)Application["TableCount"] + 1;
                Application.UnLock();

                TBtitle.Text = "";
                TBcontents.Text = "";
                LMBind();

                //采用网页重定向的方法，防止用户提交后刷新页面又提示再一次提交
                //（同时注意保留用户已填写的用户名和联系方式）
                Session["BUser"] = LMP.User;
                Session["QQorMSN"] = LMP.QQMSN;
                Response.Redirect("index.aspx");                  //为解决刷新问题
            }
            else Response.Redirect("ShowErrorMsg.aspx?name=" + LMP.User);
        }
    }

    protected void LMBind()
    {
        if(!DBControl.AccessConnection)
            LeaveMessageList.DataSource = LMManage.GetLeaveMessage(10);
        else
            LeaveMessageList.DataSource = LMManage.aGetLeaveMessage(10);
        LeaveMessageList.DataBind();
    }

    protected string ShortString(string content, string id)
    {
        //限制显示“留言内容”的字符数，避免篇幅太大
        if (content.Length > 180)
            return content.Substring(0, 150) + "...&nbsp;&nbsp;" + "<a href=\"ShowDetail.aspx?d_ID=" + id + "\">阅读全文</a>";
        else
            return content;

    }

    protected void LeaveMessageList_ItemCommand(object sender, DataListCommandEventArgs e)
    {
        //if (TBuser.Text == "")
        //{
        //    Response.Write("<Script Language=JavaScript>alert(\"提示：回复他人留言，你必须在下面的留言框输入您的用户名。\");</script>");
        //    Response.Write("<Script Language=JavaScript>this.location.href=\"#IwantToSay\"</script>");

        //    Response.Write("<script>setTimeout(\"document.all.TBuser.focus();\",1000);</script>");
        //    //上行代码也可写成两段
        //    //Response.Write("<script>setTimeout(\"Focus()\",1000);</script>");
        //    //Response.Write("<script>function Focus(){document.all.TBuser.focus();}</script>");

        //    //TBuser.Focus();   //用这个在调试时总是提示内存不可读
        //}

        #region
        //如果用户在留言页面已经输入了用户名和QQMSN，则将这些信息传到回复页
        //if (TBuser.Text != "")
            Session["YourName"] = FormatString.FormatStr(TBuser.Text);
        //if (TBQQMSN.Text != "")
            Session["QQMSN"] = FormatString.FormatStr(TBQQMSN.Text);

        //用变量保存“回复”按键所映射的相应留言的ID（参看LinkButton的CommandName属性）
        string ButtoMappedID = e.CommandName.ToString();
        //Response.Write(ButtoMappedID);     
        Session["OwnerID"] = ButtoMappedID;
        Response.Redirect("WriteBack.aspx?index=y"); //(1)
        /*//(2)用JavaScript实现自动链接页面
        Response.Write("<script language=JavaScript>window.location=\"Default2.aspx\"</script>");*/
        #endregion
    }
}
